/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.loader;

import java.io.IOException;
import java.util.Enumeration;
import org.aoju.bus.core.io.resource.Resource;
import org.aoju.bus.core.loader.AntFilter;
import org.aoju.bus.core.loader.Filter;
import org.aoju.bus.core.loader.Loader;
import org.aoju.bus.core.loader.PatternLoader;
import org.aoju.bus.core.loader.StdLoader;

public class AntLoader
extends PatternLoader
implements Loader {
    public AntLoader() {
        this(new StdLoader());
    }

    public AntLoader(ClassLoader classLoader) {
        this(new StdLoader(classLoader));
    }

    public AntLoader(Loader delegate) {
        super(delegate);
    }

    @Override
    public Enumeration<Resource> load(String pattern, boolean recursively, Filter filter) throws IOException {
        if (Math.max(pattern.indexOf(42), pattern.indexOf(63)) < 0) {
            return this.delegate.load(pattern, recursively, filter);
        }
        return super.load(pattern, recursively, filter);
    }

    @Override
    protected String path(String ant) {
        int index = 0x7FFFFFFE;
        if (ant.contains("*") && ant.indexOf(42) < index) {
            index = ant.indexOf(42);
        }
        if (ant.contains("?") && ant.indexOf(63) < index) {
            index = ant.indexOf(63);
        }
        return ant.substring(0, ant.lastIndexOf(47, index) + 1);
    }

    @Override
    protected boolean recursively(String ant) {
        return true;
    }

    @Override
    protected Filter filter(String ant) {
        return new AntFilter(ant);
    }
}

