/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.utils;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.swing.ClipboardListener;
import org.aoju.bus.core.swing.ClipboardMonitor;
import org.aoju.bus.core.swing.ImageSelection;

public class ClipboardUtils {
    public static Clipboard getClipboard() {
        return Toolkit.getDefaultToolkit().getSystemClipboard();
    }

    public static void set(Transferable contents) {
        ClipboardUtils.set(contents, null);
    }

    public static void set(Transferable contents, ClipboardOwner owner) {
        ClipboardUtils.getClipboard().setContents(contents, owner);
    }

    public static Object get(DataFlavor flavor) {
        return ClipboardUtils.get(ClipboardUtils.getClipboard().getContents(null), flavor);
    }

    public static Object get(Transferable content, DataFlavor flavor) {
        if (null != content && content.isDataFlavorSupported(flavor)) {
            try {
                return content.getTransferData(flavor);
            }
            catch (UnsupportedFlavorException | IOException e) {
                throw new InstrumentException(e);
            }
        }
        return null;
    }

    public static String getStr() {
        return (String)ClipboardUtils.get(DataFlavor.stringFlavor);
    }

    public static void setStr(String text) {
        ClipboardUtils.set(new StringSelection(text));
    }

    public static String getStr(Transferable content) {
        return (String)ClipboardUtils.get(content, DataFlavor.stringFlavor);
    }

    public static Image getImage() {
        return (Image)ClipboardUtils.get(DataFlavor.imageFlavor);
    }

    public static void setImage(Image image) {
        ClipboardUtils.set(new ImageSelection(image), null);
    }

    public static Image getImage(Transferable content) {
        return (Image)ClipboardUtils.get(content, DataFlavor.imageFlavor);
    }

    public static void listen(ClipboardListener listener) {
        ClipboardUtils.listen(listener, true);
    }

    public static void listen(ClipboardListener listener, boolean sync) {
        ClipboardUtils.listen(10, 100L, listener, sync);
    }

    public static void listen(int tryCount, long delay, ClipboardListener listener, boolean sync) {
        ClipboardMonitor.INSTANCE.setTryCount(tryCount).setDelay(delay).addListener(listener).listen(sync);
    }
}

