/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.oauth.provider;

import com.alibaba.fastjson.JSONObject;
import java.util.Objects;
import org.aoju.bus.core.consts.Normal;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.http.HttpClient;
import org.aoju.bus.oauth.Builder;
import org.aoju.bus.oauth.Context;
import org.aoju.bus.oauth.Registry;
import org.aoju.bus.oauth.magic.AccToken;
import org.aoju.bus.oauth.magic.Callback;
import org.aoju.bus.oauth.magic.Property;
import org.aoju.bus.oauth.metric.StateCache;
import org.aoju.bus.oauth.provider.DefaultProvider;

public class PinterestProvider
extends DefaultProvider {
    private static final String FAILURE = "failure";

    public PinterestProvider(Context config) {
        super(config, Registry.PINTEREST);
    }

    public PinterestProvider(Context config, StateCache stateCache) {
        super(config, Registry.PINTEREST, stateCache);
    }

    @Override
    protected AccToken getAccessToken(Callback Callback2) {
        JSONObject accessTokenObject = JSONObject.parseObject((String)this.doPostAuthorizationCode(Callback2.getCode()));
        this.checkResponse(accessTokenObject);
        return AccToken.builder().accessToken(accessTokenObject.getString("access_token")).tokenType(accessTokenObject.getString("token_type")).build();
    }

    @Override
    protected Property getUserInfo(AccToken token) {
        String userinfoUrl = this.userInfoUrl(token);
        JSONObject object = JSONObject.parseObject((String)HttpClient.get(userinfoUrl));
        this.checkResponse(object);
        JSONObject userObj = object.getJSONObject("data");
        return Property.builder().uuid(userObj.getString("id")).avatar(this.getAvatarUrl(userObj)).username(userObj.getString("username")).nickname(userObj.getString("first_name") + " " + userObj.getString("last_name")).gender(Normal.Gender.UNKNOWN).remark(userObj.getString("bio")).token(token).source(this.source.toString()).build();
    }

    private String getAvatarUrl(JSONObject userObj) {
        JSONObject jsonObject = userObj.getJSONObject("image");
        if (Objects.isNull(jsonObject)) {
            return null;
        }
        return jsonObject.getJSONObject("60x60").getString("url");
    }

    @Override
    public String authorize(String state) {
        return Builder.fromBaseUrl(this.source.authorize()).queryParam("response_type", "code").queryParam("client_id", this.config.getClientId()).queryParam("redirect_uri", this.config.getRedirectUri()).queryParam("scope", "read_public").queryParam("state", this.getRealState(state)).build();
    }

    @Override
    protected String userInfoUrl(AccToken token) {
        return Builder.fromBaseUrl(this.source.userInfo()).queryParam("access_token", token.getAccessToken()).queryParam("fields", "id,username,first_name,last_name,bio,image").build();
    }

    private void checkResponse(JSONObject object) {
        if (!object.containsKey((Object)"status") && FAILURE.equals(object.getString("status"))) {
            throw new InstrumentException(object.getString("message"));
        }
    }
}

