/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.excel.sax;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.IoUtils;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.office.excel.ExcelSaxUtils;
import org.aoju.bus.office.excel.sax.AbstractExcelSaxReader;
import org.aoju.bus.office.excel.sax.CellDataType;
import org.aoju.bus.office.excel.sax.RowHandler;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class Excel07SaxReader
extends AbstractExcelSaxReader<Excel07SaxReader>
implements ContentHandler {
    private static final String CLASS_SAXPARSER = "org.apache.xerces.parsers.SAXParser";
    private static final String C_ELEMENT = "c";
    private static final String ROW_ELEMENT = "row";
    private static final String R_ATTR = "r";
    private static final String T_ELEMENT = "t";
    private static final String S_ATTR_VALUE = "s";
    private static final String T_ATTR_VALUE = "t";
    private static final String RID_PREFIX = "rId";
    List<Object> rowCellList = new ArrayList<Object>();
    private SharedStringsTable sharedStringsTable;
    private int curRow;
    private int curCell;
    private String lastContent;
    private CellDataType cellDataType;
    private String curCoordinate;
    private String preCoordinate;
    private String maxCellCoordinate;
    private StylesTable stylesTable;
    private int numFmtIndex;
    private String numFmtString;
    private int sheetIndex;
    private RowHandler rowHandler;

    public Excel07SaxReader(RowHandler rowHandler) {
        this.rowHandler = rowHandler;
    }

    public Excel07SaxReader setRowHandler(RowHandler rowHandler) {
        this.rowHandler = rowHandler;
        return this;
    }

    @Override
    public Excel07SaxReader read(File file, int rid) throws InstrumentException {
        try {
            return this.read(OPCPackage.open((File)file), rid);
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }

    @Override
    public Excel07SaxReader read(InputStream in, int rid) throws InstrumentException {
        try {
            return this.read(OPCPackage.open((InputStream)in), rid);
        }
        catch (InstrumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }

    public Excel07SaxReader read(OPCPackage opcPackage, int rid) throws InstrumentException {
        InputStream sheetInputStream = null;
        try {
            XSSFReader xssfReader = new XSSFReader(opcPackage);
            this.stylesTable = xssfReader.getStylesTable();
            this.sharedStringsTable = xssfReader.getSharedStringsTable();
            if (rid > -1) {
                this.sheetIndex = rid;
                sheetInputStream = xssfReader.getSheet(RID_PREFIX + (rid + 1));
                this.parse(sheetInputStream);
            } else {
                this.sheetIndex = -1;
                Iterator sheetInputStreams = xssfReader.getSheetsData();
                while (sheetInputStreams.hasNext()) {
                    this.curRow = 0;
                    ++this.sheetIndex;
                    sheetInputStream = (InputStream)sheetInputStreams.next();
                    this.parse(sheetInputStream);
                }
            }
        }
        catch (InstrumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
        finally {
            IoUtils.close(sheetInputStream);
            IoUtils.close((Closeable)opcPackage);
        }
        return this;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (C_ELEMENT.equals(qName)) {
            String tempCurCoordinate = attributes.getValue(R_ATTR);
            this.preCoordinate = this.preCoordinate == null ? String.valueOf('@') : this.curCoordinate;
            this.curCoordinate = tempCurCoordinate;
            this.setCellType(attributes);
        }
        this.lastContent = "";
    }

    private void setCellType(Attributes attribute) {
        this.numFmtIndex = 0;
        this.numFmtString = "";
        this.cellDataType = CellDataType.of(attribute.getValue("t"));
        String xfIndexStr = attribute.getValue(S_ATTR_VALUE);
        if (xfIndexStr != null) {
            int xfIndex = Integer.parseInt(xfIndexStr);
            XSSFCellStyle xssfCellStyle = this.stylesTable.getStyleAt(xfIndex);
            this.numFmtIndex = xssfCellStyle.getDataFormat();
            this.numFmtString = xssfCellStyle.getDataFormatString();
            if (this.numFmtString == null) {
                this.numFmtString = BuiltinFormats.getBuiltinFormat((int)this.numFmtIndex);
            } else if (CellDataType.NUMBER == this.cellDataType && DateUtil.isADateFormat((int)this.numFmtIndex, (String)this.numFmtString)) {
                this.cellDataType = CellDataType.DATE;
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String contentStr = StringUtils.trim(this.lastContent);
        if (!"t".equals(qName)) {
            if (C_ELEMENT.equals(qName)) {
                Object value = ExcelSaxUtils.getDataValue(this.cellDataType, contentStr, this.sharedStringsTable, this.numFmtString);
                this.fillBlankCell(this.preCoordinate, this.curCoordinate, false);
                this.rowCellList.add(this.curCell++, value);
            } else if (ROW_ELEMENT.equals(qName)) {
                if (this.curRow == 0) {
                    this.maxCellCoordinate = this.curCoordinate;
                }
                if (this.maxCellCoordinate != null) {
                    this.fillBlankCell(this.curCoordinate, this.maxCellCoordinate, true);
                }
                this.rowHandler.handle(this.sheetIndex, this.curRow, this.rowCellList);
                this.rowCellList.clear();
                ++this.curRow;
                this.curCell = 0;
                this.curCoordinate = null;
                this.preCoordinate = null;
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.lastContent = this.lastContent.concat(new String(ch, start, length));
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    private void parse(InputStream sheetInputStream) throws IOException, SAXException {
        this.fetchSheetReader().parse(new InputSource(sheetInputStream));
    }

    private void fillBlankCell(String preCoordinate, String curCoordinate, boolean isEnd) {
        if (!curCoordinate.equals(preCoordinate)) {
            int len = ExcelSaxUtils.countNullCell(preCoordinate, curCoordinate);
            if (isEnd) {
                // empty if block
            }
            while (true) {
                int n = ++len;
                --len;
                if (n <= 0) break;
                this.rowCellList.add(this.curCell++, "");
            }
        }
    }

    private XMLReader fetchSheetReader() throws SAXException {
        XMLReader xmlReader = null;
        try {
            xmlReader = XMLReaderFactory.createXMLReader(CLASS_SAXPARSER);
        }
        catch (SAXException e) {
            if (e.getMessage().contains(CLASS_SAXPARSER)) {
                throw new InstrumentException("You need to add 'xerces:xercesImpl' to your project and version >= 2.11.0");
            }
            throw e;
        }
        xmlReader.setContentHandler(this);
        return xmlReader;
    }
}

