/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.storage.provider;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.model.GetObjectRequest;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.model.PutObjectResult;
import com.qcloud.cos.region.Region;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.storage.Context;
import org.aoju.bus.storage.magic.Attachs;
import org.aoju.bus.storage.magic.Readers;
import org.aoju.bus.storage.provider.AbstractProvider;

public class TencentCosProvider
extends AbstractProvider {
    private COSClient client;

    public TencentCosProvider(Context property) {
        this.property = property;
        Assert.notBlank(this.property.getPrefix(), "[prefix] not defined", new Object[0]);
        Assert.notBlank(this.property.getBucket(), "[bucket] not defined", new Object[0]);
        Assert.notBlank(this.property.getAccessKey(), "[accessKey] not defined", new Object[0]);
        Assert.notBlank(this.property.getSecretKey(), "[secretKey] not defined", new Object[0]);
        Assert.notBlank(this.property.getRegion(), "[region] not defined", new Object[0]);
        this.client = new COSClient((COSCredentials)new BasicCOSCredentials(this.property.getAccessKey(), this.property.getSecretKey()), new ClientConfig(new Region(this.property.getRegion())));
    }

    @Override
    public Readers download(String fileName) {
        return null;
    }

    @Override
    public Readers download(String bucket, String fileName) {
        this.client.getObjectMetadata(bucket, fileName);
        return new Readers("success");
    }

    @Override
    public Readers download(String bucket, String fileName, File file) {
        this.client.getObject(new GetObjectRequest(bucket, fileName), file);
        return new Readers("success");
    }

    @Override
    public Readers download(String fileName, File file) {
        return new Readers(null, "failure to provide services");
    }

    @Override
    public Readers list() {
        return new Readers(null, "failure to provide services");
    }

    @Override
    public Readers rename(String oldName, String newName) {
        return new Readers(null, "failure to provide services");
    }

    @Override
    public Readers rename(String bucket, String oldName, String newName) {
        return new Readers(null, "failure to provide services");
    }

    @Override
    public Readers upload(String fileName, byte[] content) {
        return this.upload(this.property.getBucket(), fileName, content);
    }

    @Override
    public Readers upload(String bucket, String fileName, InputStream content) {
        if (!fileName.startsWith(File.separator)) {
            fileName = File.separator + fileName;
        }
        ObjectMetadata objectMetadata = new ObjectMetadata();
        try {
            objectMetadata.setContentLength((long)content.available());
            PutObjectRequest request = new PutObjectRequest(this.property.getBucket(), fileName, content, objectMetadata);
            PutObjectResult result = this.client.putObject(request);
            if (StringUtils.isEmpty(result.getETag())) {
                return new Readers(null, "file upload failed");
            }
            return new Readers(Attachs.builder().path(this.property.getPrefix() + fileName).name(fileName).build());
        }
        catch (IOException e) {
            Logger.error("file upload failed", e.getMessage());
            return new Readers(null, "failure");
        }
    }

    @Override
    public Readers upload(String bucket, String fileName, byte[] content) {
        if (!fileName.startsWith(File.separator)) {
            fileName = File.separator + fileName;
        }
        ObjectMetadata objectMetadata = new ObjectMetadata();
        objectMetadata.setContentLength((long)content.length);
        PutObjectRequest request = new PutObjectRequest(this.property.getBucket(), fileName, (InputStream)new ByteArrayInputStream(content), objectMetadata);
        PutObjectResult result = this.client.putObject(request);
        if (StringUtils.isEmpty(result.getETag())) {
            return new Readers(null, "file upload failed");
        }
        return new Readers(Attachs.builder().name(fileName).path(this.property.getPrefix() + fileName).build());
    }

    @Override
    public Readers remove(String fileName) {
        return new Readers(null, "failure to provide services");
    }

    @Override
    public Readers remove(String bucket, String fileName) {
        this.client.deleteObject(bucket, fileName);
        return new Readers(null, "success");
    }

    @Override
    public Readers remove(String bucket, Path path) {
        return new Readers(null, "failure to provide services");
    }
}

