/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.tracer.binding.jms;

import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import org.aoju.bus.tracer.Backend;
import org.aoju.bus.tracer.Builder;
import org.aoju.bus.tracer.config.TraceFilterConfiguration;
import org.aoju.bus.tracer.transport.HttpHeaderTransport;

public class TraceMessageProducer
implements MessageProducer {
    private final MessageProducer delegate;
    private final Backend backend;
    private final HttpHeaderTransport httpHeaderSerialization;

    TraceMessageProducer(MessageProducer delegate, Backend backend) {
        this.delegate = delegate;
        this.backend = backend;
        this.httpHeaderSerialization = new HttpHeaderTransport();
    }

    public TraceMessageProducer(MessageProducer delegate) {
        this.delegate = delegate;
        this.backend = Builder.getBackend();
        this.httpHeaderSerialization = new HttpHeaderTransport();
    }

    protected void writeTraceContextToMessage(Message message) throws JMSException {
        if (!this.backend.isEmpty() && this.backend.getConfiguration().shouldProcessContext(TraceFilterConfiguration.Channel.AsyncDispatch)) {
            Map<String, String> filteredContext = this.backend.getConfiguration().filterDeniedParams(this.backend.copyToMap(), TraceFilterConfiguration.Channel.AsyncDispatch);
            String contextAsString = this.httpHeaderSerialization.render(filteredContext);
            message.setStringProperty("TPIC", contextAsString);
        }
    }

    public void send(Message message) throws JMSException {
        this.writeTraceContextToMessage(message);
        this.delegate.send(message);
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.writeTraceContextToMessage(message);
        this.delegate.send(message, deliveryMode, priority, timeToLive);
    }

    public void send(Destination destination, Message message) throws JMSException {
        this.writeTraceContextToMessage(message);
        this.delegate.send(destination, message);
    }

    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.writeTraceContextToMessage(message);
        this.delegate.send(destination, message, deliveryMode, priority, timeToLive);
    }

    public boolean getDisableMessageID() throws JMSException {
        return this.delegate.getDisableMessageID();
    }

    public void setDisableMessageID(boolean value) throws JMSException {
        this.delegate.setDisableMessageID(value);
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        return this.delegate.getDisableMessageTimestamp();
    }

    public void setDisableMessageTimestamp(boolean value) throws JMSException {
        this.delegate.setDisableMessageTimestamp(value);
    }

    public int getDeliveryMode() throws JMSException {
        return this.delegate.getDeliveryMode();
    }

    public void setDeliveryMode(int deliveryMode) throws JMSException {
        this.delegate.setDeliveryMode(deliveryMode);
    }

    public int getPriority() throws JMSException {
        return this.delegate.getPriority();
    }

    public void setPriority(int defaultPriority) throws JMSException {
        this.delegate.setPriority(defaultPriority);
    }

    public long getTimeToLive() throws JMSException {
        return this.delegate.getTimeToLive();
    }

    public void setTimeToLive(long timeToLive) throws JMSException {
        this.delegate.setTimeToLive(timeToLive);
    }

    public Destination getDestination() throws JMSException {
        return this.delegate.getDestination();
    }

    public void close() throws JMSException {
        this.delegate.close();
    }
}

