/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.oauth.provider;

import com.alibaba.fastjson.JSONObject;
import org.aoju.bus.core.consts.Normal;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.http.HttpClient;
import org.aoju.bus.oauth.Builder;
import org.aoju.bus.oauth.Context;
import org.aoju.bus.oauth.Registry;
import org.aoju.bus.oauth.magic.AccToken;
import org.aoju.bus.oauth.magic.Callback;
import org.aoju.bus.oauth.magic.Message;
import org.aoju.bus.oauth.magic.Property;
import org.aoju.bus.oauth.metric.StateCache;
import org.aoju.bus.oauth.provider.DefaultProvider;

public class BaiduProvider
extends DefaultProvider {
    public BaiduProvider(Context config) {
        super(config, Registry.BAIDU);
    }

    public BaiduProvider(Context config, StateCache stateCache) {
        super(config, Registry.BAIDU, stateCache);
    }

    @Override
    protected AccToken getAccessToken(Callback Callback2) {
        String response = this.doPostAuthorizationCode(Callback2.getCode());
        return this.getAuthToken(response);
    }

    @Override
    protected Property getUserInfo(AccToken token) {
        JSONObject object = JSONObject.parseObject((String)this.doGetUserInfo(token));
        this.checkResponse(object);
        return Property.builder().uuid(object.getString("userid")).username(object.getString("username")).nickname(object.getString("username")).avatar(this.getAvatar(object)).remark(object.getString("userdetail")).gender(Normal.Gender.getGender(object.getString("sex"))).token(token).source(this.source.toString()).build();
    }

    private String getAvatar(JSONObject object) {
        String protrait = object.getString("portrait");
        return StringUtils.isEmpty(protrait) ? null : String.format("http://himg.bdimg.com/sys/portrait/item/%s.jpg", protrait);
    }

    @Override
    public Message revoke(AccToken token) {
        JSONObject object = JSONObject.parseObject((String)this.doGetRevoke(token));
        this.checkResponse(object);
        Builder.Status status = object.getIntValue("result") == 1 ? Builder.Status.SUCCESS : Builder.Status.FAILURE;
        return Message.builder().errcode(status.getCode()).errmsg(status.getMsg()).build();
    }

    @Override
    public Message refresh(AccToken token) {
        String refreshUrl = Builder.fromBaseUrl(this.source.refresh()).queryParam("grant_type", "refresh_token").queryParam("refresh_token", token.getRefreshToken()).queryParam("client_id", this.config.getClientId()).queryParam("client_secret", this.config.getClientSecret()).build();
        return Message.builder().errcode(Builder.Status.SUCCESS.getCode()).data(this.getAuthToken(HttpClient.get(refreshUrl))).build();
    }

    @Override
    public String authorize(String state) {
        return Builder.fromBaseUrl(this.source.authorize()).queryParam("response_type", "code").queryParam("client_id", this.config.getClientId()).queryParam("redirect_uri", this.config.getRedirectUri()).queryParam("display", "popup").queryParam("state", this.getRealState(state)).build();
    }

    private void checkResponse(JSONObject object) {
        if (object.containsKey((Object)"error") || object.containsKey((Object)"error_code")) {
            String msg = object.containsKey((Object)"error_description") ? object.getString("error_description") : object.getString("error_msg");
            throw new InstrumentException(msg);
        }
    }

    private AccToken getAuthToken(String response) {
        JSONObject accessTokenObject = JSONObject.parseObject((String)response);
        this.checkResponse(accessTokenObject);
        return AccToken.builder().accessToken(accessTokenObject.getString("access_token")).refreshToken(accessTokenObject.getString("refresh_token")).scope(accessTokenObject.getString("scope")).expireIn(accessTokenObject.getIntValue("expires_in")).build();
    }
}

