/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.oauth.provider;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import org.aoju.bus.core.codec.Base64;
import org.aoju.bus.core.consts.Normal;
import org.aoju.bus.core.key.ObjectID;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.http.HttpClient;
import org.aoju.bus.oauth.Builder;
import org.aoju.bus.oauth.Context;
import org.aoju.bus.oauth.Registry;
import org.aoju.bus.oauth.magic.AccToken;
import org.aoju.bus.oauth.magic.Callback;
import org.aoju.bus.oauth.magic.Message;
import org.aoju.bus.oauth.magic.Property;
import org.aoju.bus.oauth.metric.StateCache;
import org.aoju.bus.oauth.provider.DefaultProvider;

public class ElemeProvider
extends DefaultProvider {
    public ElemeProvider(Context config) {
        super(config, Registry.ELEME);
    }

    public ElemeProvider(Context config, StateCache stateCache) {
        super(config, Registry.ELEME, stateCache);
    }

    @Override
    protected AccToken getAccessToken(Callback Callback2) {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("client_id", this.config.getClientId());
        header.put("redirect_uri", this.config.getRedirectUri());
        header.put("code", Callback2.getCode());
        header.put("grant_type", "authorization_code");
        this.setHeader(header);
        String response = HttpClient.post(this.source.accessToken(), null, header);
        JSONObject object = JSONObject.parseObject((String)response);
        this.checkResponse(object);
        return AccToken.builder().accessToken(object.getString("access_token")).refreshToken(object.getString("refresh_token")).tokenType(object.getString("token_type")).expireIn(object.getIntValue("expires_in")).build();
    }

    @Override
    protected Property getUserInfo(AccToken token) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        String action = "eleme.user.getUser";
        long timestamp = System.currentTimeMillis();
        HashMap<String, String> metasHashMap = new HashMap<String, String>();
        metasHashMap.put("app_key", this.config.getClientId());
        metasHashMap.put("timestamp", "" + timestamp);
        String signature = ElemeProvider.generateElemeSignature(this.config.getClientId(), this.config.getClientSecret(), timestamp, action, token.getAccessToken(), parameters);
        String requestId = this.getRequestId();
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("nop", "1.0.0");
        header.put("id", requestId);
        header.put("action", action);
        header.put("token", token.getAccessToken());
        header.put("metas", ((Object)metasHashMap).toString());
        header.put("params", ((Object)parameters).toString());
        header.put("signature", signature);
        this.setHeader(header, "application/json; charset=utf-8", requestId);
        String response = HttpClient.post(this.source.userInfo(), null, header);
        JSONObject object = JSONObject.parseObject((String)response);
        if (object.containsKey((Object)"name")) {
            throw new InstrumentException(object.getString("message"));
        }
        if (object.containsKey((Object)"error") && null != object.get((Object)"error")) {
            throw new InstrumentException(object.getJSONObject("error").getString("message"));
        }
        JSONObject result = object.getJSONObject("result");
        return Property.builder().uuid(result.getString("userId")).username(result.getString("userName")).nickname(result.getString("userName")).gender(Normal.Gender.UNKNOWN).token(token).source(this.source.toString()).build();
    }

    @Override
    public Message refresh(AccToken oldToken) {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("refresh_token", oldToken.getRefreshToken());
        header.put("grant_type", "refresh_token");
        this.setHeader(header);
        String response = HttpClient.post(this.source.refresh(), null, header);
        JSONObject object = JSONObject.parseObject((String)response);
        this.checkResponse(object);
        return Message.builder().errcode(Builder.Status.SUCCESS.getCode()).data(AccToken.builder().accessToken(object.getString("access_token")).refreshToken(object.getString("refresh_token")).tokenType(object.getString("token_type")).expireIn(object.getIntValue("expires_in")).build()).build();
    }

    @Override
    public String authorize(String state) {
        return Builder.fromBaseUrl(super.authorize(state)).queryParam("scope", "all").build();
    }

    private String getBasic(String appKey, String appSecret) {
        StringBuilder sb = new StringBuilder();
        String encodeToString = Base64.encode((appKey + ":" + appSecret).getBytes());
        sb.append("Basic").append(" ").append(encodeToString);
        return sb.toString();
    }

    private void setHeader(Map<String, String> header) {
        this.setHeader(header, "application/x-www-form-urlencoded;charset=UTF-8", this.getRequestId());
        header.put("Authorization", this.getBasic(this.config.getClientId(), this.config.getClientSecret()));
    }

    private void setHeader(Map<String, String> header, String contentType, String requestId) {
        header.put("Accept", "text/xml,text/javascript,text/html");
        header.put("Content-Type", contentType);
        header.put("Accept-Encoding", "gzip");
        header.put("User-Agent", "eleme-openapi-java-sdk");
        header.put("x-eleme-requestid", requestId);
    }

    private String getRequestId() {
        return (ObjectID.id() + "|" + System.currentTimeMillis()).toUpperCase();
    }

    private void checkResponse(JSONObject object) {
        if (object.containsKey((Object)"error")) {
            throw new InstrumentException(object.getString("error_description"));
        }
    }
}

