/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.oauth.provider;

import com.alibaba.fastjson.JSONObject;
import java.text.MessageFormat;
import org.aoju.bus.core.consts.Normal;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.http.HttpClient;
import org.aoju.bus.oauth.Builder;
import org.aoju.bus.oauth.Context;
import org.aoju.bus.oauth.Registry;
import org.aoju.bus.oauth.magic.AccToken;
import org.aoju.bus.oauth.magic.Callback;
import org.aoju.bus.oauth.magic.Message;
import org.aoju.bus.oauth.magic.Property;
import org.aoju.bus.oauth.metric.StateCache;
import org.aoju.bus.oauth.provider.DefaultProvider;

public class MiProvider
extends DefaultProvider {
    public MiProvider(Context config) {
        super(config, Registry.MI);
    }

    public MiProvider(Context config, StateCache stateCache) {
        super(config, Registry.MI, stateCache);
    }

    @Override
    protected AccToken getAccessToken(Callback Callback2) {
        return this.getToken(this.accessTokenUrl(Callback2.getCode()));
    }

    private AccToken getToken(String accessTokenUrl) {
        String response = HttpClient.get(accessTokenUrl);
        JSONObject object = JSONObject.parseObject((String)StringUtils.replace(response, "&&&START&&&", ""));
        if (object.containsKey((Object)"error")) {
            throw new InstrumentException(object.getString("error_description"));
        }
        return AccToken.builder().accessToken(object.getString("access_token")).expireIn(object.getIntValue("expires_in")).scope(object.getString("scope")).tokenType(object.getString("token_type")).refreshToken(object.getString("refresh_token")).openId(object.getString("openId")).macAlgorithm(object.getString("mac_algorithm")).macKey(object.getString("mac_key")).build();
    }

    @Override
    protected Property getUserInfo(AccToken token) {
        JSONObject object = JSONObject.parseObject((String)this.doGetUserInfo(token));
        if ("error".equalsIgnoreCase(object.getString("result"))) {
            throw new InstrumentException(object.getString("description"));
        }
        JSONObject user = object.getJSONObject("data");
        Property property = Property.builder().uuid(token.getOpenId()).username(user.getString("miliaoNick")).nickname(user.getString("miliaoNick")).avatar(user.getString("miliaoIcon")).email(user.getString("mail")).gender(Normal.Gender.UNKNOWN).token(token).source(this.source.toString()).build();
        String emailPhoneUrl = MessageFormat.format("{0}?clientId={1}&token={2}", "https://open.account.xiaomi.com/user/phoneAndEmail", this.config.getClientId(), token.getAccessToken());
        JSONObject userEmailPhone = JSONObject.parseObject((String)HttpClient.get(emailPhoneUrl));
        if (!"error".equalsIgnoreCase(userEmailPhone.getString("result"))) {
            JSONObject emailPhone = userEmailPhone.getJSONObject("data");
            property.setEmail(emailPhone.getString("email"));
        }
        return property;
    }

    @Override
    public Message refresh(AccToken token) {
        return Message.builder().errcode(Builder.Status.SUCCESS.getCode()).data(this.getToken(this.refreshTokenUrl(token.getRefreshToken()))).build();
    }

    @Override
    public String authorize(String state) {
        return Builder.fromBaseUrl(this.source.authorize()).queryParam("response_type", "code").queryParam("client_id", this.config.getClientId()).queryParam("redirect_uri", this.config.getRedirectUri()).queryParam("scope", "user/profile%20user/openIdV2%20user/phoneAndEmail").queryParam("skip_confirm", "false").queryParam("state", this.getRealState(state)).build();
    }

    @Override
    protected String userInfoUrl(AccToken token) {
        return Builder.fromBaseUrl(this.source.userInfo()).queryParam("clientId", this.config.getClientId()).queryParam("token", token.getAccessToken()).build();
    }
}

