/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus;

import org.aoju.bus.core.utils.StringUtils;

public class Version {
    private boolean complete = true;

    public static String get() {
        return "5.0.3.RELEASE";
    }

    public static String major() {
        return StringUtils.split((CharSequence)Version.get(), ".")[0];
    }

    public static String minor() {
        return StringUtils.split((CharSequence)Version.get(), ".")[1];
    }

    public static String stage() {
        return StringUtils.split((CharSequence)Version.get(), ".")[2];
    }

    public static String level() {
        return StringUtils.split((CharSequence)Version.get(), ".")[3];
    }

    private static int compare(String v1, String v2, boolean complete) {
        if (v1 == v2) {
            return 0;
        }
        if (v1 == null) {
            return -1;
        }
        if (v2 == null) {
            return 1;
        }
        if ((v1 = v1.trim()).equals(v2 = v2.trim())) {
            return 0;
        }
        String[] v1s = v1.split("\\.");
        String[] v2s = v2.split("\\.");
        int v1sLen = v1s.length;
        int v2sLen = v2s.length;
        int len = complete ? Math.max(v1sLen, v2sLen) : Math.min(v1sLen, v2sLen);
        for (int i = 0; i < len; ++i) {
            String c2;
            String c1 = len > v1sLen || null == v1s[i] ? "" : v1s[i];
            int result = c1.compareTo(c2 = len > v2sLen || null == v2s[i] ? "" : v2s[i]);
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    public Version inComplete() {
        this.complete = false;
        return this;
    }

    public boolean eq(String version) {
        return this.compare(version) == 0;
    }

    public boolean ne(String version) {
        return this.compare(version) != 0;
    }

    public boolean gt(String version) {
        return this.compare(version) > 0;
    }

    public boolean gte(String version) {
        return this.compare(version) >= 0;
    }

    public boolean lt(String version) {
        return this.compare(version) < 0;
    }

    public boolean lte(String version) {
        return this.compare(version) <= 0;
    }

    private int compare(String version) {
        return Version.compare(Version.get(), version, this.complete);
    }
}

