/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.mapper.builder;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.aoju.bus.mapper.MapperException;
import org.aoju.bus.mapper.builder.MapperTemplate;
import org.aoju.bus.mapper.criteria.Assert;
import org.aoju.bus.mapper.entity.Config;
import org.aoju.bus.mapper.provider.EmptyProvider;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.builder.annotation.ProviderSqlSource;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.session.Configuration;

public class MapperBuilder {
    private final Map<String, Boolean> msIdSkip = new ConcurrentHashMap<String, Boolean>();
    private List<Class<?>> registerClass = new ArrayList();
    private Map<Class<?>, MapperTemplate> registerMapper = new ConcurrentHashMap();
    private Map<String, MapperTemplate> msIdCache = new ConcurrentHashMap<String, MapperTemplate>();
    private Config config = new Config();

    public MapperBuilder() {
    }

    public MapperBuilder(Properties properties) {
        this();
        this.setProperties(properties);
    }

    private MapperTemplate fromMapperClass(Class<?> mapperClass) {
        Method[] methods = mapperClass.getDeclaredMethods();
        Class templateClass = null;
        Class tempClass = null;
        HashSet<String> methodSet = new HashSet<String>();
        for (Method method : methods) {
            SelectProvider provider;
            if (method.isAnnotationPresent(SelectProvider.class)) {
                provider = method.getAnnotation(SelectProvider.class);
                tempClass = provider.type();
                methodSet.add(method.getName());
            } else if (method.isAnnotationPresent(InsertProvider.class)) {
                provider = method.getAnnotation(InsertProvider.class);
                tempClass = provider.type();
                methodSet.add(method.getName());
            } else if (method.isAnnotationPresent(DeleteProvider.class)) {
                provider = method.getAnnotation(DeleteProvider.class);
                tempClass = provider.type();
                methodSet.add(method.getName());
            } else if (method.isAnnotationPresent(UpdateProvider.class)) {
                provider = method.getAnnotation(UpdateProvider.class);
                tempClass = provider.type();
                methodSet.add(method.getName());
            }
            if (templateClass == null) {
                templateClass = tempClass;
                continue;
            }
            if (templateClass == tempClass) continue;
            throw new MapperException("\u4e00\u4e2a\u901a\u7528Mapper\u4e2d\u53ea\u5141\u8bb8\u5b58\u5728\u4e00\u4e2aMapperTemplate\u5b50\u7c7b!");
        }
        if (templateClass == null || !MapperTemplate.class.isAssignableFrom(templateClass)) {
            templateClass = EmptyProvider.class;
        }
        MapperTemplate mapperTemplate = null;
        try {
            mapperTemplate = (MapperTemplate)templateClass.getConstructor(Class.class, MapperBuilder.class).newInstance(mapperClass, this);
        }
        catch (Exception e) {
            throw new MapperException("\u5b9e\u4f8b\u5316MapperTemplate\u5bf9\u8c61\u5931\u8d25:" + e.getMessage());
        }
        for (String methodName : methodSet) {
            try {
                mapperTemplate.addMethodMap(methodName, templateClass.getMethod(methodName, MappedStatement.class));
            }
            catch (NoSuchMethodException e) {
                throw new MapperException(templateClass.getCanonicalName() + "\u4e2d\u7f3a\u5c11" + methodName + "\u65b9\u6cd5!");
            }
        }
        return mapperTemplate;
    }

    public void registerMapper(Class<?> mapperClass) {
        Class<?>[] interfaces;
        if (!this.registerMapper.containsKey(mapperClass)) {
            this.registerClass.add(mapperClass);
            this.registerMapper.put(mapperClass, this.fromMapperClass(mapperClass));
        }
        if ((interfaces = mapperClass.getInterfaces()) != null && interfaces.length > 0) {
            for (Class<?> anInterface : interfaces) {
                this.registerMapper(anInterface);
            }
        }
    }

    public void registerMapper(String mapperClass) {
        try {
            this.registerMapper(Class.forName(mapperClass));
        }
        catch (ClassNotFoundException e) {
            throw new MapperException("\u6ce8\u518c\u901a\u7528Mapper[" + mapperClass + "]\u5931\u8d25\uff0c\u627e\u4e0d\u5230\u8be5\u901a\u7528Mapper!");
        }
    }

    public boolean isMapperMethod(String msId) {
        if (this.msIdSkip.get(msId) != null) {
            return this.msIdSkip.get(msId);
        }
        for (Map.Entry<Class<?>, MapperTemplate> entry : this.registerMapper.entrySet()) {
            if (!entry.getValue().supportMethod(msId)) continue;
            this.msIdSkip.put(msId, true);
            this.msIdCache.put(msId, entry.getValue());
            return true;
        }
        this.msIdSkip.put(msId, false);
        return false;
    }

    public boolean isExtendCommonMapper(Class<?> mapperInterface) {
        for (Class<?> mapperClass : this.registerClass) {
            if (!mapperClass.isAssignableFrom(mapperInterface)) continue;
            return true;
        }
        return false;
    }

    public void ifEmptyRegisterDefaultInterface() {
        if (this.registerClass.size() == 0) {
            this.registerMapper("org.aoju.bus.mapper.common.Mapper");
        }
    }

    public void processConfiguration(Configuration configuration) {
        this.processConfiguration(configuration, null);
    }

    public void processConfiguration(Configuration configuration, Class<?> mapperInterface) {
        String prefix = mapperInterface != null ? mapperInterface.getCanonicalName() : "";
        for (Object object : new ArrayList(configuration.getMappedStatements())) {
            MappedStatement ms;
            if (!(object instanceof MappedStatement) || !(ms = (MappedStatement)object).getId().startsWith(prefix) || !this.isMapperMethod(ms.getId()) || !(ms.getSqlSource() instanceof ProviderSqlSource)) continue;
            this.setSqlSource(ms);
        }
    }

    public Config getConfig() {
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
        if (config.getMappers() != null && config.getMappers().size() > 0) {
            for (Class mapperClass : config.getMappers()) {
                this.registerMapper(mapperClass);
            }
        }
    }

    public void setProperties(Properties properties) {
        this.config.setProperties(properties);
        String mapper = null;
        if (properties != null) {
            mapper = properties.getProperty("mappers");
        }
        if (Assert.isNotEmpty(mapper)) {
            String[] mappers;
            for (String mapperClass : mappers = mapper.split(",")) {
                if (mapperClass.length() <= 0) continue;
                this.registerMapper(mapperClass);
            }
        }
    }

    public void setSqlSource(MappedStatement ms) {
        MapperTemplate mapperTemplate = this.msIdCache.get(ms.getId());
        try {
            if (mapperTemplate != null) {
                mapperTemplate.setSqlSource(ms);
            }
        }
        catch (Exception e) {
            throw new MapperException(e);
        }
    }
}

