/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket.spring.support;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Objects;
import org.aoju.bus.core.lang.exception.SocketException;
import org.aoju.bus.socket.spring.support.MessageFrom;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.ConcurrentWebSocketSessionDecorator;

public class MessageMatcher {
    private PathMatcher matcher = new AntPathMatcher();
    private ObjectMapper objectMapper = new ObjectMapper();

    public boolean matches(String pattern, String type, MessageFrom message) {
        if (!Objects.equals(type, message.getType())) {
            return false;
        }
        String destination = message.getDestination();
        if (pattern == null) {
            pattern = "";
        }
        if (destination == null) {
            destination = "";
        }
        return this.matcher.match(pattern, destination);
    }

    public void sendMessage(WebSocketSession session, Object message) {
        String content;
        if (message == null) {
            return;
        }
        if (message instanceof String) {
            content = message.toString();
        } else {
            try {
                content = this.objectMapper.writeValueAsString(message);
            }
            catch (JsonProcessingException e) {
                throw new SocketException("json\u8f6c\u6362\u51fa\u9519", e);
            }
        }
        ConcurrentWebSocketSessionDecorator decorator = new ConcurrentWebSocketSessionDecorator(session, -1, -1);
        try {
            decorator.sendMessage((WebSocketMessage)new TextMessage((CharSequence)(" " + content)));
        }
        catch (IOException e) {
            throw new SocketException("\u53d1\u9001\u6d88\u606f\u51fa\u9519", e);
        }
    }
}

