/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.cache.support.cache;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PreDestroy;
import org.aoju.bus.cache.support.cache.Cache;
import org.aoju.bus.cache.support.serialize.BaseSerializer;
import org.aoju.bus.cache.support.serialize.Hessian2Serializer;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Pipeline;

public class RedisCache
implements Cache {
    private BaseSerializer serializer;
    private JedisPool jedisPool;

    public RedisCache(JedisPool jedisPool) {
        this(jedisPool, new Hessian2Serializer());
    }

    public RedisCache(JedisPool jedisPool, BaseSerializer serializer) {
        this.jedisPool = jedisPool;
        this.serializer = serializer;
    }

    @Override
    public Object read(String key) {
        try (Jedis client = this.jedisPool.getResource();){
            byte[] bytes = client.get(key.getBytes());
            Object t = this.serializer.deserialize(bytes);
            return t;
        }
    }

    @Override
    public void write(String key, Object value, long expire) {
        try (Jedis client = this.jedisPool.getResource();){
            byte[] bytesValue = this.serializer.serialize(value);
            if (expire == 0L) {
                client.set(key.getBytes(), bytesValue);
            } else {
                client.psetex(key.getBytes(), expire, bytesValue);
            }
        }
    }

    @Override
    public Map<String, Object> read(Collection<String> keys) {
        try (Jedis client = this.jedisPool.getResource();){
            List bytesValues = client.mget(RedisCache.toByteArray(keys));
            Map<String, Object> map = RedisCache.toObjectMap(keys, bytesValues, this.serializer);
            return map;
        }
    }

    @Override
    public void write(Map<String, Object> keyValueMap, long expire) {
        try (Jedis client = this.jedisPool.getResource();){
            byte[][] kvs = RedisCache.toByteArray(keyValueMap, this.serializer);
            if (expire == 0L) {
                client.mset(kvs);
            } else {
                Pipeline pipeline = client.pipelined();
                for (int i = 0; i < kvs.length; i += 2) {
                    pipeline.psetex(kvs[i], expire, kvs[i + 1]);
                }
                pipeline.sync();
            }
        }
    }

    @Override
    public void remove(String ... keys) {
        try (Jedis client = this.jedisPool.getResource();){
            client.del(keys);
        }
    }

    @Override
    public void clear() {
        this.tearDown();
    }

    @PreDestroy
    public void tearDown() {
        if (this.jedisPool != null && !this.jedisPool.isClosed()) {
            this.jedisPool.destroy();
        }
    }

    static byte[][] toByteArray(Map<String, Object> keyValueMap, BaseSerializer serializer) {
        byte[][] kvs = new byte[keyValueMap.size() * 2][];
        int index = 0;
        for (Map.Entry<String, Object> entry : keyValueMap.entrySet()) {
            kvs[index++] = entry.getKey().getBytes();
            kvs[index++] = serializer.serialize(entry.getValue());
        }
        return kvs;
    }

    static byte[][] toByteArray(Collection<String> keys) {
        byte[][] array = new byte[keys.size()][];
        int index = 0;
        for (String str : keys) {
            array[index++] = str.getBytes();
        }
        return array;
    }

    static Map<String, Object> toObjectMap(Collection<String> keys, List<byte[]> bytesValues, BaseSerializer serializer) {
        int index = 0;
        HashMap<String, Object> result = new HashMap<String, Object>(keys.size());
        for (String key : keys) {
            Object value = serializer.deserialize(bytesValues.get(index++));
            result.put(key, value);
        }
        return result;
    }
}

