/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.codec;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.aoju.bus.core.codec.Base64Decoder;
import org.aoju.bus.core.codec.Base64Encoder;
import org.aoju.bus.core.utils.FileUtils;
import org.aoju.bus.core.utils.IoUtils;

public class Base64 {
    public static final byte[] STANDARD_ENCODE_TABLE = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    public static final byte[] URL_SAFE_ENCODE_TABLE = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 45, 95};
    public static final byte[] DECODE_TABLE = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, 62, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -2, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, 63, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51};
    public static final byte PADDING = -2;

    private static String encode(byte[] in, byte[] map) {
        int length = (in.length + 2) / 3 * 4;
        byte[] out = new byte[length];
        int index = 0;
        int end = in.length - in.length % 3;
        for (int i = 0; i < end; i += 3) {
            out[index++] = map[(in[i] & 0xFF) >> 2];
            out[index++] = map[(in[i] & 3) << 4 | (in[i + 1] & 0xFF) >> 4];
            out[index++] = map[(in[i + 1] & 0xF) << 2 | (in[i + 2] & 0xFF) >> 6];
            out[index++] = map[in[i + 2] & 0x3F];
        }
        switch (in.length % 3) {
            case 1: {
                out[index++] = map[(in[end] & 0xFF) >> 2];
                out[index++] = map[(in[end] & 3) << 4];
                out[index++] = 61;
                out[index++] = 61;
                break;
            }
            case 2: {
                out[index++] = map[(in[end] & 0xFF) >> 2];
                out[index++] = map[(in[end] & 3) << 4 | (in[end + 1] & 0xFF) >> 4];
                out[index++] = map[(in[end + 1] & 0xF) << 2];
                out[index++] = 61;
            }
        }
        return new String(out, StandardCharsets.US_ASCII);
    }

    public static void encode(byte[] src, int srcPos, int srcLen, byte[] dest, int destPos) {
        byte b2;
        byte b1;
        if (srcPos < 0 || srcLen < 0 || srcLen > src.length - srcPos) {
            throw new IndexOutOfBoundsException();
        }
        int destLen = srcLen * 4 / 3 + 3 & 0xFFFFFFFC;
        if (destPos < 0 || destLen > dest.length - destPos) {
            throw new IndexOutOfBoundsException();
        }
        int n = srcLen / 3;
        int r = srcLen - 3 * n;
        while (n-- > 0) {
            int n2 = destPos++;
            b1 = src[srcPos++];
            dest[n2] = STANDARD_ENCODE_TABLE[b1 >>> 2 & 0x3F];
            int n3 = destPos++;
            b2 = src[srcPos++];
            dest[n3] = STANDARD_ENCODE_TABLE[(b1 & 3) << 4 | b2 >>> 4 & 0xF];
            int n4 = destPos++;
            byte b3 = src[srcPos++];
            dest[n4] = STANDARD_ENCODE_TABLE[(b2 & 0xF) << 2 | b3 >>> 6 & 3];
            dest[destPos++] = STANDARD_ENCODE_TABLE[b3 & 0x3F];
        }
        if (r > 0) {
            if (r == 1) {
                int n5 = destPos++;
                b1 = src[srcPos];
                dest[n5] = STANDARD_ENCODE_TABLE[b1 >>> 2 & 0x3F];
                dest[destPos++] = STANDARD_ENCODE_TABLE[(b1 & 3) << 4];
                dest[destPos++] = 61;
                dest[destPos++] = 61;
            } else {
                int n6 = destPos++;
                b1 = src[srcPos++];
                dest[n6] = STANDARD_ENCODE_TABLE[b1 >>> 2 & 0x3F];
                int n7 = destPos++;
                b2 = src[srcPos];
                dest[n7] = STANDARD_ENCODE_TABLE[(b1 & 3) << 4 | b2 >>> 4 & 0xF];
                dest[destPos++] = STANDARD_ENCODE_TABLE[(b2 & 0xF) << 2];
                dest[destPos++] = 61;
            }
        }
    }

    public static void decode(char[] ch, int off, int len, OutputStream out) throws IOException {
        while ((len -= 2) >= 0) {
            int n = off++;
            byte b2 = DECODE_TABLE[ch[off++]];
            out.write((byte)(DECODE_TABLE[ch[n]] << 2 | b2 >>> 4));
            if (len-- == 0 || ch[off] == '=') break;
            byte b3 = DECODE_TABLE[ch[off++]];
            out.write((byte)(b2 << 4 | b3 >>> 2));
            if (len-- == 0 || ch[off] == '=') break;
            out.write((byte)(b3 << 6 | DECODE_TABLE[ch[off++]]));
        }
    }

    public static byte[] encode(byte[] in, boolean lineSep) {
        return Base64Encoder.encode(in, lineSep);
    }

    public static byte[] encodeUrlSafe(byte[] in, boolean lineSep) {
        return Base64Encoder.encodeUrlSafe(in, lineSep);
    }

    public static String encode(String source) {
        return Base64Encoder.encode(source);
    }

    public static String encodeUrlSafe(String source) {
        return Base64Encoder.encodeUrlSafe(source);
    }

    public static String encode(String source, String charset) {
        return Base64Encoder.encode(source, charset);
    }

    public static String encodeUrlSafe(String source, String charset) {
        return Base64Encoder.encodeUrlSafe(source, charset);
    }

    public static String encode(String source, Charset charset) {
        return Base64Encoder.encode(source, charset);
    }

    public static String encodeUrlSafe(String source, Charset charset) {
        return Base64Encoder.encodeUrlSafe(source, charset);
    }

    public static String encode(byte[] source) {
        return Base64Encoder.encode(source);
    }

    public static String encodeUrlSafe(byte[] source) {
        return Base64Encoder.encodeUrlSafe(source);
    }

    public static String encode(InputStream in) {
        return Base64Encoder.encode(IoUtils.readBytes(in));
    }

    public static String encodeUrlSafe(InputStream in) {
        return Base64Encoder.encodeUrlSafe(IoUtils.readBytes(in));
    }

    public static String encode(File file) {
        return Base64Encoder.encode(FileUtils.readBytes(file));
    }

    public static String encodeUrlSafe(File file) {
        return Base64Encoder.encodeUrlSafe(FileUtils.readBytes(file));
    }

    public static String encode(byte[] source, String charset) {
        return Base64Encoder.encode(source, charset);
    }

    public static String encodeUrlSafe(byte[] source, String charset) {
        return Base64Encoder.encodeUrlSafe(source, charset);
    }

    public static String encode(byte[] source, Charset charset) {
        return Base64Encoder.encode(source, charset);
    }

    public static String encodeUrlSafe(byte[] source, Charset charset) {
        return Base64Encoder.encodeUrlSafe(source, charset);
    }

    public static byte[] encode(byte[] arr, boolean isMultiLine, boolean isUrlSafe) {
        return Base64Encoder.encode(arr, isMultiLine, isUrlSafe);
    }

    public static String decodeStr(String source) {
        return Base64Decoder.decodeStr(source);
    }

    public static String decodeStr(String source, String charset) {
        return Base64Decoder.decodeStr(source, charset);
    }

    public static String decodeStr(String source, Charset charset) {
        return Base64Decoder.decodeStr(source, charset);
    }

    public static File decodeToFile(String base64, File destFile) {
        return FileUtils.writeBytes(Base64Decoder.decode(base64), destFile);
    }

    public static void decodeToStream(String base64, OutputStream out, boolean isCloseOut) {
        IoUtils.write(out, isCloseOut, Base64Decoder.decode(base64));
    }

    public static byte[] decode(String base64) {
        return Base64Decoder.decode(base64);
    }

    public static byte[] decode(String source, String charset) {
        return Base64Decoder.decode(source, charset);
    }

    public static byte[] decode(String source, Charset charset) {
        return Base64Decoder.decode(source, charset);
    }

    public static byte[] decode(byte[] in) {
        return Base64Decoder.decode(in);
    }
}

