/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.key;

import java.util.Date;

public class LongID {
    private static final int COUNTER_HEX_DIGITS = 2;
    private static final int SERVER_HEX_DIGITS = 3;
    private static final int COUNTER_MAX = 255;
    private static final int SERVER_MAX = 4095;
    private static final String ZEROES = "00000000000";
    private long millisPrevious = 0L;
    private long counterWithinThisMilli = 0L;
    private final String serverIdAsHex;

    public LongID() {
        this(0L);
    }

    public LongID(long serverId) {
        if (serverId > 4095L || serverId < 0L) {
            throw new IllegalArgumentException("Server Id must be in the range 0-4095");
        }
        String asHex = Long.toHexString(serverId);
        this.serverIdAsHex = ZEROES.substring(0, 3 - asHex.length()) + asHex;
    }

    public synchronized long id() {
        long millisCurrent = System.currentTimeMillis();
        if (this.millisPrevious != millisCurrent) {
            this.millisPrevious = millisCurrent;
            this.counterWithinThisMilli = 0L;
        } else {
            if (this.counterWithinThisMilli >= 255L) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                return this.id();
            }
            ++this.counterWithinThisMilli;
        }
        this.millisPrevious = millisCurrent;
        String millisAsHex = Long.toHexString(millisCurrent);
        String counterAsHex = Long.toHexString(this.counterWithinThisMilli);
        counterAsHex = ZEROES.substring(0, 2 - counterAsHex.length()) + counterAsHex;
        return Long.decode("0x" + millisAsHex + counterAsHex + this.serverIdAsHex);
    }

    public static Date getDate(long longId) {
        String hexInput = Long.toHexString(longId);
        if (hexInput.length() < 6) {
            throw new IllegalArgumentException("Input is too short to be a LongId");
        }
        return new Date(Long.decode("0x" + hexInput.substring(0, hexInput.length() - 5)));
    }

    public static long getServerId(long longId) {
        String hexInput = Long.toHexString(longId);
        if (hexInput.length() < 6) {
            throw new IllegalArgumentException("Input is too short to be a LongId");
        }
        return Long.decode("0x" + hexInput.substring(hexInput.length() - 3));
    }

    public static long getCounter(long longId) {
        String hexInput = Long.toHexString(longId);
        if (hexInput.length() < 6) {
            throw new IllegalArgumentException("Input is too short to be a LongId");
        }
        return Long.decode("0x" + hexInput.substring(hexInput.length() - 5, hexInput.length() - 3));
    }
}

