/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.crypto.asymmetric;

import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.aoju.bus.core.codec.Base64;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.crypto.Builder;
import org.aoju.bus.crypto.asymmetric.KeyType;

public class Keys<T extends Keys<T>> {
    protected String algorithm;
    protected PublicKey publicKey;
    protected PrivateKey privateKey;
    protected Lock lock = new ReentrantLock();

    public Keys(String algorithm, PrivateKey privateKey, PublicKey publicKey) {
        this.init(algorithm, privateKey, publicKey);
    }

    protected T init(String algorithm, PrivateKey privateKey, PublicKey publicKey) {
        this.algorithm = algorithm;
        if (null == privateKey && null == publicKey) {
            this.initKeys();
        } else {
            if (null != privateKey) {
                this.privateKey = privateKey;
            }
            if (null != publicKey) {
                this.publicKey = publicKey;
            }
        }
        return (T)this;
    }

    public T initKeys() {
        KeyPair keyPair = Builder.generateKeyPair(this.algorithm);
        this.publicKey = keyPair.getPublic();
        this.privateKey = keyPair.getPrivate();
        return (T)this;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public T setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
        return (T)this;
    }

    public String getPublicKeyBase64() {
        PublicKey publicKey = this.getPublicKey();
        return null == publicKey ? null : Base64.encode(publicKey.getEncoded());
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public T setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
        return (T)this;
    }

    public String getPrivateKeyBase64() {
        return Base64.encode(this.getPrivateKey().getEncoded());
    }

    protected Key getKeyByType(KeyType type) {
        switch (type) {
            case PrivateKey: {
                if (null == this.privateKey) {
                    throw new NullPointerException("Private key must not null when use it !");
                }
                return this.privateKey;
            }
            case PublicKey: {
                if (null == this.publicKey) {
                    throw new NullPointerException("Public key must not null when use it !");
                }
                return this.publicKey;
            }
        }
        throw new InstrumentException("Uknown key type: " + (Object)((Object)type));
    }
}

