/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health;

import java.io.PrintWriter;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryManagerMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.util.List;
import java.util.Properties;
import org.aoju.bus.core.convert.Convert;
import org.aoju.bus.core.lang.Singleton;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.health.HostInfo;
import org.aoju.bus.health.JavaInfo;
import org.aoju.bus.health.JavaRuntimeInfo;
import org.aoju.bus.health.JavaSpecInfo;
import org.aoju.bus.health.JvmInfo;
import org.aoju.bus.health.JvmSpecInfo;
import org.aoju.bus.health.OsInfo;
import org.aoju.bus.health.RuntimeInfo;
import org.aoju.bus.health.UserInfo;

public class HealthUtils {
    public static String get(String name, String defaultValue) {
        return StringUtils.nullToDefault(HealthUtils.get(name, false), defaultValue);
    }

    public static String get(String name, boolean quiet) {
        try {
            return System.getProperty(name);
        }
        catch (SecurityException e) {
            throw new InstrumentException(e);
        }
    }

    public static String get(String key) {
        return HealthUtils.get(key, null);
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        String value = HealthUtils.get(key);
        if (value == null) {
            return defaultValue;
        }
        if ((value = value.trim().toLowerCase()).isEmpty()) {
            return true;
        }
        if ("true".equals(value) || "yes".equals(value) || "1".equals(value)) {
            return true;
        }
        if ("false".equals(value) || "no".equals(value) || "0".equals(value)) {
            return false;
        }
        return defaultValue;
    }

    public static long getInt(String key, int defaultValue) {
        return Convert.toInt(HealthUtils.get(key), defaultValue).intValue();
    }

    public static long getLong(String key, long defaultValue) {
        return Convert.toLong(HealthUtils.get(key), defaultValue);
    }

    public static Properties props() {
        return System.getProperties();
    }

    public static long getCurrentPID() {
        return Long.parseLong(HealthUtils.getRuntimeMXBean().getName().split("@")[0]);
    }

    public static ClassLoadingMXBean getClassLoadingMXBean() {
        return ManagementFactory.getClassLoadingMXBean();
    }

    public static MemoryMXBean getMemoryMXBean() {
        return ManagementFactory.getMemoryMXBean();
    }

    public static ThreadMXBean getThreadMXBean() {
        return ManagementFactory.getThreadMXBean();
    }

    public static RuntimeMXBean getRuntimeMXBean() {
        return ManagementFactory.getRuntimeMXBean();
    }

    public static CompilationMXBean getCompilationMXBean() {
        return ManagementFactory.getCompilationMXBean();
    }

    public static OperatingSystemMXBean getOperatingSystemMXBean() {
        return ManagementFactory.getOperatingSystemMXBean();
    }

    public static List<MemoryPoolMXBean> getMemoryPoolMXBeans() {
        return ManagementFactory.getMemoryPoolMXBeans();
    }

    public static List<MemoryManagerMXBean> getMemoryManagerMXBeans() {
        return ManagementFactory.getMemoryManagerMXBeans();
    }

    public static List<GarbageCollectorMXBean> getGarbageCollectorMXBeans() {
        return ManagementFactory.getGarbageCollectorMXBeans();
    }

    public static JvmSpecInfo getJvmSpecInfo() {
        return Singleton.get(JvmSpecInfo.class, new Object[0]);
    }

    public static JvmInfo getJvmInfo() {
        return Singleton.get(JvmInfo.class, new Object[0]);
    }

    public static JavaSpecInfo getJavaSpecInfo() {
        return Singleton.get(JavaSpecInfo.class, new Object[0]);
    }

    public static JavaInfo getJavaInfo() {
        return Singleton.get(JavaInfo.class, new Object[0]);
    }

    public static JavaRuntimeInfo getJavaRuntimeInfo() {
        return Singleton.get(JavaRuntimeInfo.class, new Object[0]);
    }

    public static OsInfo getOsInfo() {
        return Singleton.get(OsInfo.class, new Object[0]);
    }

    public static UserInfo getUserInfo() {
        return Singleton.get(UserInfo.class, new Object[0]);
    }

    public static HostInfo getHostInfo() {
        return Singleton.get(HostInfo.class, new Object[0]);
    }

    public static RuntimeInfo getRuntimeInfo() {
        return Singleton.get(RuntimeInfo.class, new Object[0]);
    }

    public static void dumpSystemInfo() {
        HealthUtils.dumpSystemInfo(new PrintWriter(System.out));
    }

    public static void dumpSystemInfo(PrintWriter out) {
        out.println("--------------");
        out.println(HealthUtils.getJvmSpecInfo());
        out.println("--------------");
        out.println(HealthUtils.getJvmInfo());
        out.println("--------------");
        out.println(HealthUtils.getJavaSpecInfo());
        out.println("--------------");
        out.println(HealthUtils.getJavaInfo());
        out.println("--------------");
        out.println(HealthUtils.getJavaRuntimeInfo());
        out.println("--------------");
        out.println(HealthUtils.getOsInfo());
        out.println("--------------");
        out.println(HealthUtils.getUserInfo());
        out.println("--------------");
        out.println(HealthUtils.getHostInfo());
        out.println("--------------");
        out.println(HealthUtils.getRuntimeInfo());
        out.println("--------------");
        out.flush();
    }

    protected static void append(StringBuilder builder, String caption, Object value) {
        builder.append(caption).append(StringUtils.nullToDefault(Convert.toString(value), "[n/a]")).append("\n");
    }
}

