/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.http;

import java.io.File;
import java.io.IOException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.aoju.bus.core.consts.MediaType;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.ArrayUtils;
import org.aoju.bus.core.utils.MapUtils;
import org.aoju.bus.core.utils.ObjectUtils;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.http.Call;
import org.aoju.bus.http.Callback;
import org.aoju.bus.http.Client;
import org.aoju.bus.http.Proxy;
import org.aoju.bus.http.Request;
import org.aoju.bus.http.Response;
import org.aoju.bus.http.accord.ConnectionPool;
import org.aoju.bus.http.bodys.MultipartBody;
import org.aoju.bus.http.bodys.RequestBody;
import org.aoju.bus.http.offers.Dispatcher;
import org.aoju.bus.http.offers.Dns;
import org.aoju.bus.logger.Logger;

public class HttpClient
extends Client {
    private static Client client = new HttpClient(new X509TrustManager());

    public HttpClient() {
        this(30, 30, 30);
    }

    public HttpClient(X509TrustManager x509TrustManager) {
        this(null, null, 30, 30, 30, 64, 5, 5, 5, HttpClient.createTrustAllSSLFactory(x509TrustManager), x509TrustManager, HttpClient.createTrustAllHostnameVerifier());
    }

    public HttpClient(int connTimeout, int readTimeout, int writeTimeout) {
        this(null, null, connTimeout, readTimeout, writeTimeout, 64, 5, 5, 5);
    }

    public HttpClient(int connTimeout, int readTimeout, int writeTimeout, int maxRequests, int maxRequestsPerHost, int maxIdleConnections, int keepAliveDuration) {
        this(null, null, connTimeout, readTimeout, writeTimeout, maxRequests, maxRequestsPerHost, maxIdleConnections, keepAliveDuration);
    }

    public HttpClient(Dns dns, Proxy proxy, int connTimeout, int readTimeout, int writeTimeout, int maxRequests, int maxRequestsPerHost, int maxIdleConnections, int keepAliveDuration) {
        this(dns, proxy, connTimeout, readTimeout, writeTimeout, maxRequests, maxRequestsPerHost, maxIdleConnections, keepAliveDuration, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpClient(Dns dns, Proxy proxy, int connTimeout, int readTimeout, int writeTimeout, int maxRequests, int maxRequestsPerHost, int maxIdleConnections, int keepAliveDuration, SSLSocketFactory sslSocketFactory, javax.net.ssl.X509TrustManager x509TrustManager, HostnameVerifier hostnameVerifier) {
        Class<HttpClient> clazz = HttpClient.class;
        synchronized (HttpClient.class) {
            Dispatcher dispatcher = new Dispatcher();
            dispatcher.setMaxRequests(maxRequests);
            dispatcher.setMaxRequestsPerHost(maxRequestsPerHost);
            ConnectionPool connectionPool = new ConnectionPool(maxIdleConnections, keepAliveDuration, TimeUnit.MINUTES);
            Client.Builder builder = new Client.Builder();
            builder.dispatcher(dispatcher);
            builder.connectionPool(connectionPool);
            builder.addNetworkInterceptor(chain -> {
                Request request = chain.request();
                return chain.proceed(request);
            });
            if (ObjectUtils.isNotEmpty(dns)) {
                builder.dns(hostname -> {
                    try {
                        return dns.lookup(hostname);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return Dns.SYSTEM.lookup(hostname);
                    }
                });
            }
            if (ObjectUtils.isNotEmpty(proxy)) {
                builder.proxy(proxy.proxy());
                if (proxy.user != null && proxy.password != null) {
                    builder.proxyAuthenticator(proxy.authenticator());
                }
            }
            builder.connectTimeout(connTimeout, TimeUnit.SECONDS);
            builder.readTimeout(readTimeout, TimeUnit.SECONDS);
            builder.writeTimeout(writeTimeout, TimeUnit.SECONDS);
            if (ObjectUtils.isNotEmpty(sslSocketFactory)) {
                builder.sslSocketFactory(sslSocketFactory, x509TrustManager);
            }
            if (ObjectUtils.isNotEmpty(hostnameVerifier)) {
                builder.hostnameVerifier(hostnameVerifier);
            }
            client = builder.build();
            // ** MonitorExit[var13_13] (shouldn't be in output)
            return;
        }
    }

    public static String get(String url) {
        return HttpClient.get(url, "UTF-8");
    }

    public static String get(String url, String charset) {
        return HttpClient.execute(Builder.builder().url(url).requestCharset(charset).responseCharset(charset).build());
    }

    public static String get(String url, boolean isAsync) {
        if (isAsync) {
            return HttpClient.enqueue(Builder.builder().url(url).method("GET").build());
        }
        return HttpClient.get(url);
    }

    public static String get(String url, Map<String, Object> queryMap) {
        return HttpClient.get(url, queryMap, null, "UTF-8");
    }

    public static String get(String url, Map<String, Object> queryMap, Map<String, String> headerMap) {
        return HttpClient.get(url, queryMap, headerMap, "UTF-8");
    }

    public static String get(String url, Map<String, Object> queryMap, Map<String, String> headerMap, String charset) {
        return HttpClient.execute(Builder.builder().url(url).headerMap(headerMap).queryMap(queryMap).requestCharset(charset).responseCharset(charset).build());
    }

    public static void get(String url, Callback callback) {
        Request request = new Request.Builder().url(url).get().build();
        Call call = client.newCall(request);
        call.enqueue(callback);
    }

    public static void post(String url, Map<String, Object> queryMap, Callback callback) {
        StringBuilder data = new StringBuilder();
        if (ObjectUtils.isNotEmpty(queryMap)) {
            Set<String> keys = queryMap.keySet();
            for (String key : keys) {
                data.append(key).append("=").append(queryMap.get(key)).append("&");
            }
        }
        RequestBody requestBody = RequestBody.create(MediaType.TEXT_HTML_TYPE, data.toString());
        Request request = new Request.Builder().url(url).post(requestBody).build();
        Call call = client.newCall(request);
        call.enqueue(callback);
    }

    public static String post(String url) {
        return HttpClient.post(url, null);
    }

    public static String post(String url, Map<String, Object> formMap) {
        String data = "";
        if (MapUtils.isNotEmpty(formMap)) {
            data = formMap.entrySet().stream().map(entry -> String.format("%s=%s", entry.getKey(), entry.getValue())).collect(Collectors.joining("&"));
        }
        return HttpClient.post(url, data, "application/x-www-form-urlencoded");
    }

    public static String post(String url, String data, String mediaType) {
        return HttpClient.post(url, data, mediaType, "UTF-8");
    }

    public static String post(String url, String data, String mediaType, String charset) {
        return HttpClient.execute(Builder.builder().url(url).method("POST").data(data).mediaType(mediaType).requestCharset(charset).responseCharset(charset).build());
    }

    public static String post(String url, Map<String, Object> queryMap, String mediaType) {
        return HttpClient.post(url, queryMap, mediaType, "UTF-8");
    }

    public static String post(String url, Map<String, Object> queryMap, Map<String, String> headerMap) {
        return HttpClient.post(url, queryMap, headerMap, "UTF-8");
    }

    public static String post(String url, Map<String, Object> queryMap, String mediaType, String charset) {
        return HttpClient.execute(Builder.builder().url(url).method("POST").queryMap(queryMap).mediaType(mediaType).requestCharset(charset).responseCharset(charset).build());
    }

    public static String post(String url, Map<String, Object> queryMap, Map<String, String> headerMap, String mediaType) {
        return HttpClient.post(url, queryMap, headerMap, mediaType, "UTF-8");
    }

    public static String post(String url, Map<String, Object> queryMap, Map<String, String> headerMap, String mediaType, String charset) {
        return HttpClient.execute(Builder.builder().url(url).method("POST").headerMap(headerMap).queryMap(queryMap).mediaType(mediaType).requestCharset(charset).responseCharset(charset).build());
    }

    public static String post(String url, Map<String, Object> params, List<String> pathList) {
        MediaType mediaType = MediaType.get("application/x-www-form-urlencoded;UTF-8");
        RequestBody bodyParams = RequestBody.create(mediaType, params.toString());
        MultipartBody.Builder requestBodyBuilder = new MultipartBody.Builder().setType(MediaType.MULTIPART_FORM_DATA_TYPE).addFormDataPart("params", "", bodyParams);
        for (String path : pathList) {
            File file = new File(path);
            requestBodyBuilder.addFormDataPart("file", file.getName(), RequestBody.create(mediaType, new File(path)));
        }
        MultipartBody requestBody = requestBodyBuilder.build();
        Request request = new Request.Builder().url(url).post(requestBody).build();
        String result = "";
        try {
            Response response = client.newCall(request).execute();
            if (response.isSuccessful()) {
                assert (response.body() != null);
                byte[] bytes = response.body().bytes();
                result = new String(bytes, "UTF-8");
            }
        }
        catch (Exception e) {
            Logger.error(">>>>>>>>error requesting HTTP upload file form request<<<<<<<<", e);
        }
        return result;
    }

    private static String execute(Builder builder) {
        if (StringUtils.isBlank(builder.requestCharset)) {
            builder.requestCharset = "UTF-8";
        }
        if (StringUtils.isBlank(builder.responseCharset)) {
            builder.responseCharset = "UTF-8";
        }
        if (StringUtils.isBlank(builder.method)) {
            builder.method = "GET";
        }
        if (StringUtils.isBlank(builder.mediaType)) {
            builder.mediaType = "application/x-www-form-urlencoded";
        }
        if (builder.tracer) {
            Logger.info(">>>>>>>>Builder[{}]<<<<<<<<", builder.toString());
        }
        String url = builder.url;
        Request.Builder request = new Request.Builder();
        if (MapUtils.isNotEmpty(builder.queryMap)) {
            String queryParams = builder.queryMap.entrySet().stream().map(entry -> String.format("%s=%s", entry.getKey(), entry.getValue())).collect(Collectors.joining("&"));
            url = String.format("%s%s%s", url, url.contains("?") ? "&" : "?", queryParams);
        }
        request.url(url);
        if (MapUtils.isNotEmpty(builder.headerMap)) {
            builder.headerMap.forEach(request::addHeader);
        }
        String method = builder.method.toUpperCase();
        String mediaType = String.format("%s;charset=%s", builder.mediaType, builder.requestCharset);
        if (StringUtils.equals(method, "GET")) {
            request.get();
        } else if (ArrayUtils.contains(new String[]{"POST", "PUT", "DELETE", "PATCH"}, method)) {
            String data = StringUtils.isEmpty(builder.data) ? builder.queryMap.toString() : builder.data;
            RequestBody requestBody = RequestBody.create(MediaType.get(mediaType), data);
            request.method(method, requestBody);
        } else {
            throw new InstrumentException(String.format(">>>>>>>>request method not found [%s]<<<<<<<<", method));
        }
        String result = "";
        try {
            Response response = client.newCall(request.build()).execute();
            if (response.isSuccessful()) {
                assert (response.body() != null);
                byte[] bytes = response.body().bytes();
                result = new String(bytes, builder.responseCharset);
            }
            if (builder.tracer) {
                Logger.info(">>>>>>>>Url[{}],response[{}]<<<<<<<<", url, result);
            }
        }
        catch (Exception e) {
            Logger.error(">>>>>>>>Builder[{}] error<<<<<<<<", builder.toString(), e);
        }
        return result;
    }

    private static String enqueue(final Builder builder) {
        if (StringUtils.isBlank(builder.requestCharset)) {
            builder.requestCharset = "UTF-8";
        }
        if (StringUtils.isBlank(builder.responseCharset)) {
            builder.responseCharset = "UTF-8";
        }
        if (StringUtils.isBlank(builder.method)) {
            builder.method = "GET";
        }
        if (StringUtils.isBlank(builder.mediaType)) {
            builder.mediaType = "application/x-www-form-urlencoded";
        }
        if (builder.tracer) {
            Logger.info(">>>>>>>>Builder[{}]<<<<<<<<", builder.toString());
        }
        String url = builder.url;
        Request.Builder request = new Request.Builder();
        if (MapUtils.isNotEmpty(builder.queryMap)) {
            String queryParams = builder.queryMap.entrySet().stream().map(entry -> String.format("%s=%s", entry.getKey(), entry.getValue())).collect(Collectors.joining("&"));
            url = String.format("%s%s%s", url, url.contains("?") ? "&" : "?", queryParams);
        }
        request.url(url);
        if (MapUtils.isNotEmpty(builder.headerMap)) {
            builder.headerMap.forEach(request::addHeader);
        }
        String method = builder.method.toUpperCase();
        String mediaType = String.format("%s;charset=%s", builder.mediaType, builder.requestCharset);
        if (StringUtils.equals(method, "GET")) {
            request.get();
        } else if (ArrayUtils.contains(new String[]{"POST", "PUT", "DELETE", "PATCH"}, method)) {
            String data = StringUtils.isEmpty(builder.data) ? builder.queryMap.toString() : builder.data;
            RequestBody requestBody = RequestBody.create(MediaType.get(mediaType), data);
            request.method(method, requestBody);
        } else {
            throw new InstrumentException(String.format(">>>>>>>>request method not found[%s]<<<<<<<<", method));
        }
        final String[] result = new String[]{""};
        final String finalUrl = url;
        Call call = client.newCall(request.build());
        call.enqueue(new Callback(){

            @Override
            public void onFailure(Call call, IOException e) {
                Logger.info(String.format(">>>>>>>>Url[%s]failure<<<<<<<<", finalUrl), new Object[0]);
            }

            @Override
            public void onResponse(Call call, Response response) throws IOException {
                if (response.isSuccessful()) {
                    assert (response.body() != null);
                    byte[] bytes = response.body().bytes();
                    result[0] = new String(bytes, builder.responseCharset);
                    if (builder.tracer) {
                        Logger.info(">>>>>>>>Url[{}],response[{}]<<<<<<<<", finalUrl, result[0]);
                    }
                }
            }
        });
        return result[0];
    }

    private static SSLSocketFactory createTrustAllSSLFactory(X509TrustManager X509TrustManager2) {
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, new TrustManager[]{X509TrustManager2}, new SecureRandom());
            return sc.getSocketFactory();
        }
        catch (Exception ignored) {
            ignored.printStackTrace();
            return null;
        }
    }

    private static HostnameVerifier createTrustAllHostnameVerifier() {
        return (hostname, session) -> true;
    }

    private static class Builder {
        private String url;
        private String method;
        private String data;
        private String mediaType;
        private Map<String, Object> queryMap;
        private Map<String, String> headerMap;
        private String requestCharset;
        private String responseCharset;
        private boolean tracer;

        Builder(String url, String method, String data, String mediaType, Map<String, Object> queryMap, Map<String, String> headerMap, String requestCharset, String responseCharset, boolean tracer) {
            this.url = url;
            this.method = method;
            this.data = data;
            this.mediaType = mediaType;
            this.queryMap = queryMap;
            this.headerMap = headerMap;
            this.requestCharset = requestCharset;
            this.responseCharset = responseCharset;
            this.tracer = tracer;
        }

        public static BuilderBuilder builder() {
            return new BuilderBuilder();
        }

        public String toString() {
            return "HttpClient.Builder(url=" + this.url + ", method=" + this.method + ", data=" + this.data + ", mediaType=" + this.mediaType + ", queryMap=" + this.queryMap + ", headerMap=" + this.headerMap + ", requestCharset=" + this.requestCharset + ", responseCharset=" + this.responseCharset + ", tracer=" + this.tracer + ")";
        }

        public static class BuilderBuilder {
            private String url;
            private String method;
            private String data;
            private String mediaType;
            private Map<String, Object> queryMap;
            private Map<String, String> headerMap;
            private String requestCharset;
            private String responseCharset;
            private boolean tracer;

            BuilderBuilder() {
            }

            public BuilderBuilder url(String url) {
                this.url = url;
                return this;
            }

            public BuilderBuilder method(String method) {
                this.method = method;
                return this;
            }

            public BuilderBuilder data(String data) {
                this.data = data;
                return this;
            }

            public BuilderBuilder mediaType(String mediaType) {
                this.mediaType = mediaType;
                return this;
            }

            public BuilderBuilder queryMap(Map<String, Object> queryMap) {
                this.queryMap = queryMap;
                return this;
            }

            public BuilderBuilder headerMap(Map<String, String> headerMap) {
                this.headerMap = headerMap;
                return this;
            }

            public BuilderBuilder requestCharset(String requestCharset) {
                this.requestCharset = requestCharset;
                return this;
            }

            public BuilderBuilder responseCharset(String responseCharset) {
                this.responseCharset = responseCharset;
                return this;
            }

            public BuilderBuilder tracer(boolean tracer) {
                this.tracer = tracer;
                return this;
            }

            public Builder build() {
                return new Builder(this.url, this.method, this.data, this.mediaType, this.queryMap, this.headerMap, this.requestCharset, this.responseCharset, this.tracer);
            }

            public String toString() {
                return "HttpClient.Builder.BuilderBuilder(url=" + this.url + ", method=" + this.method + ", data=" + this.data + ", mediaType=" + this.mediaType + ", queryMap=" + this.queryMap + ", headerMap=" + this.headerMap + ", requestCharset=" + this.requestCharset + ", responseCharset=" + this.responseCharset + ", tracer=" + this.tracer + ")";
            }
        }
    }

    private static class X509TrustManager
    implements javax.net.ssl.X509TrustManager {
        private X509TrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

