/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.limiter.resource;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.aoju.bus.core.utils.ClassUtils;
import org.aoju.bus.core.utils.CollUtils;
import org.aoju.bus.limiter.Parser;
import org.aoju.bus.limiter.resource.LimitedResource;
import org.aoju.bus.limiter.resource.LimitedResourceSource;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.MethodClassKey;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.AnnotationUtils;

public class DefaultLimitedResourceSource
implements LimitedResourceSource {
    private static final Collection<LimitedResource> NULL_CACHING_ATTRIBUTE = Collections.emptyList();
    private final Map<Object, Collection<LimitedResource>> cache = new ConcurrentHashMap<Object, Collection<LimitedResource>>(1024);
    private final Set<Parser> annotationParsers;

    public DefaultLimitedResourceSource(Parser ... annotationParsers) {
        LinkedHashSet<Parser> parsers = new LinkedHashSet<Parser>(annotationParsers.length);
        Collections.addAll(parsers, annotationParsers);
        this.annotationParsers = parsers;
    }

    @Override
    public Collection<LimitedResource> getLimitedResource(Class<?> targetClass, Method method) {
        MethodClassKey key = new MethodClassKey(method, targetClass);
        Collection<LimitedResource> retVal = this.cache.get(key);
        if (retVal != null) {
            return retVal;
        }
        retVal = this.computeLimitedResource(method, targetClass);
        if (CollUtils.isEmpty(retVal)) {
            this.cache.put(key, NULL_CACHING_ATTRIBUTE);
            return null;
        }
        this.cache.put(key, retVal);
        return retVal;
    }

    private Collection<LimitedResource> computeLimitedResource(Method method, Class<?> targetClass) {
        Method specificMethod = AopUtils.getMostSpecificMethod((Method)method, targetClass);
        Collection<LimitedResource> reDef = this.findLimitedResource(specificMethod);
        if (!CollUtils.isEmpty(reDef)) {
            return reDef;
        }
        reDef = this.findLimitedResource(specificMethod.getDeclaringClass());
        if (!CollUtils.isEmpty(reDef) && ClassUtils.isUserLevelMethod(specificMethod)) {
            return reDef;
        }
        if (specificMethod != method) {
            reDef = this.findLimitedResource(method);
            if (!CollUtils.isEmpty(reDef)) {
                return reDef;
            }
            reDef = this.findLimitedResource(method.getDeclaringClass());
            if (!CollUtils.isEmpty(reDef) && ClassUtils.isUserLevelMethod(method)) {
                return reDef;
            }
        }
        return null;
    }

    private Collection<LimitedResource> findLimitedResource(Method method) {
        return this.findLimitedResourceFromAnnotatedElement(method);
    }

    private Collection<LimitedResource> findLimitedResource(Class clazz) {
        return this.findLimitedResourceFromAnnotatedElement(clazz);
    }

    private Collection<LimitedResource> findLimitedResourceFromAnnotatedElement(AnnotatedElement ae) {
        Annotation[] annotations = ae.getAnnotations();
        ArrayList retVal = null;
        for (Parser parser : this.annotationParsers) {
            for (Annotation ai : annotations) {
                if (!ai.annotationType().equals(parser.getSupportAnnotation())) continue;
                if (retVal == null) {
                    retVal = new ArrayList();
                }
                AnnotationAttributes attributes = AnnotationUtils.getAnnotationAttributes((AnnotatedElement)ae, (Annotation)ai);
                retVal.add(parser.parseLimiterAnnotation(attributes));
            }
        }
        return retVal;
    }
}

