/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket.origin.plugins.ssl;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.socket.origin.plugins.ssl.Completion;
import org.aoju.bus.socket.origin.plugins.ssl.Handshake;
import org.aoju.bus.socket.origin.plugins.ssl.SSLConfig;

public class SSLService {
    private SSLContext sslContext;
    private SSLConfig config;
    private Completion handshakeCompletion = new Completion(this);

    public SSLService(SSLConfig config) {
        this.init(config);
    }

    private void init(SSLConfig config) {
        try {
            TrustManager[] trustManagers;
            this.config = config;
            KeyManager[] keyManagers = null;
            if (config.getKeyFile() != null) {
                KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
                KeyStore ks = KeyStore.getInstance("JKS");
                ks.load(new FileInputStream(config.getKeyFile()), config.getKeystorePassword().toCharArray());
                kmf.init(ks, config.getKeyPassword().toCharArray());
                keyManagers = kmf.getKeyManagers();
            }
            if (config.getTrustFile() != null) {
                KeyStore ts = KeyStore.getInstance("JKS");
                ts.load(new FileInputStream(config.getTrustFile()), config.getTrustPassword().toCharArray());
                TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
                tmf.init(ts);
                trustManagers = tmf.getTrustManagers();
            } else {
                trustManagers = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                    }

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return new X509Certificate[0];
                    }
                }};
            }
            this.sslContext = SSLContext.getInstance("TLS");
            this.sslContext.init(keyManagers, trustManagers, new SecureRandom());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Handshake createSSLEngine(AsynchronousSocketChannel socketChannel) {
        try {
            Handshake handshakeModel = new Handshake();
            SSLEngine sslEngine = this.sslContext.createSSLEngine();
            SSLSession session = sslEngine.getSession();
            sslEngine.setUseClientMode(this.config.isClientMode());
            if (!this.config.isClientMode()) {
                switch (this.config.getClientAuth()) {
                    case OPTIONAL: {
                        sslEngine.setWantClientAuth(true);
                        break;
                    }
                    case REQUIRE: {
                        sslEngine.setNeedClientAuth(true);
                        break;
                    }
                    case NONE: {
                        break;
                    }
                    default: {
                        throw new Error("Unknown auth " + (Object)((Object)this.config.getClientAuth()));
                    }
                }
            }
            handshakeModel.setSslEngine(sslEngine);
            handshakeModel.setAppWriteBuffer(ByteBuffer.allocate(0));
            handshakeModel.setNetWriteBuffer(ByteBuffer.allocate(session.getPacketBufferSize()));
            handshakeModel.getNetWriteBuffer().flip();
            handshakeModel.setAppReadBuffer(ByteBuffer.allocate(1));
            handshakeModel.setNetReadBuffer(ByteBuffer.allocate(1));
            sslEngine.beginHandshake();
            handshakeModel.setSocketChannel(socketChannel);
            return handshakeModel;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void doHandshake(Handshake handshakeModel) {
        try {
            ByteBuffer netReadBuffer = handshakeModel.getNetReadBuffer();
            ByteBuffer appReadBuffer = handshakeModel.getAppReadBuffer();
            ByteBuffer netWriteBuffer = handshakeModel.getNetWriteBuffer();
            ByteBuffer appWriteBuffer = handshakeModel.getAppWriteBuffer();
            SSLEngine engine = handshakeModel.getSslEngine();
            if (handshakeModel.isEof()) {
                Logger.warn("the ssl handshake is terminated", new Object[0]);
                handshakeModel.setFinished(true);
                return;
            }
            block26: while (!handshakeModel.isFinished()) {
                SSLEngineResult.HandshakeStatus handshakeStatus = engine.getHandshakeStatus();
                switch (handshakeStatus) {
                    case NEED_UNWRAP: {
                        netReadBuffer.flip();
                        if (!netReadBuffer.hasRemaining()) {
                            netReadBuffer.clear();
                            handshakeModel.getSocketChannel().read(netReadBuffer, handshakeModel, this.handshakeCompletion);
                            return;
                        }
                        SSLEngineResult result = engine.unwrap(netReadBuffer, appReadBuffer);
                        netReadBuffer.compact();
                        if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
                            handshakeModel.setFinished(true);
                            netReadBuffer.clear();
                        }
                        switch (result.getStatus()) {
                            case OK: {
                                continue block26;
                            }
                            case BUFFER_OVERFLOW: {
                                appReadBuffer = this.enlargeApplicationBuffer(engine, appReadBuffer);
                                handshakeModel.setAppReadBuffer(appReadBuffer);
                                continue block26;
                            }
                            case BUFFER_UNDERFLOW: {
                                netReadBuffer = this.handleBufferUnderflow(engine.getSession(), netReadBuffer);
                                handshakeModel.setNetReadBuffer(netReadBuffer);
                                handshakeModel.getSocketChannel().read(netReadBuffer, handshakeModel, this.handshakeCompletion);
                                return;
                            }
                        }
                        throw new IllegalStateException("Invalid SSL status: " + (Object)((Object)result.getStatus()));
                    }
                    case NEED_WRAP: {
                        if (netWriteBuffer.hasRemaining()) {
                            Logger.warn("\u6570\u636e\u672a\u8f93\u51fa\u5b8c\u6bd5...", new Object[0]);
                            handshakeModel.getSocketChannel().write(netWriteBuffer, handshakeModel, this.handshakeCompletion);
                            return;
                        }
                        netWriteBuffer.clear();
                        SSLEngineResult result = engine.wrap(appWriteBuffer, netWriteBuffer);
                        switch (result.getStatus()) {
                            case OK: {
                                appWriteBuffer.clear();
                                netWriteBuffer.flip();
                                if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
                                    handshakeModel.setFinished(true);
                                }
                                handshakeModel.getSocketChannel().write(netWriteBuffer, handshakeModel, this.handshakeCompletion);
                                return;
                            }
                            case BUFFER_OVERFLOW: {
                                Logger.warn("NEED_WRAP BUFFER_OVERFLOW", new Object[0]);
                                netWriteBuffer = this.enlargePacketBuffer(engine.getSession(), netWriteBuffer);
                                if (netWriteBuffer.position() > 0) {
                                    netWriteBuffer.compact();
                                } else {
                                    netWriteBuffer.position(netWriteBuffer.limit());
                                    netWriteBuffer.limit(netWriteBuffer.capacity());
                                }
                                handshakeModel.setNetWriteBuffer(netWriteBuffer);
                                continue block26;
                            }
                            case BUFFER_UNDERFLOW: {
                                throw new SSLException("Buffer underflow occured after a wrap. I don't think we should ever get here.");
                            }
                            case CLOSED: {
                                try {
                                    netWriteBuffer.flip();
                                    netReadBuffer.clear();
                                }
                                catch (Exception e) {
                                    Logger.error("Failed to send server's CLOSE message due to socket channel's failure.", new Object[0]);
                                }
                                continue block26;
                            }
                        }
                        throw new IllegalStateException("Invalid SSL status: " + (Object)((Object)result.getStatus()));
                    }
                    case NEED_TASK: {
                        Runnable task;
                        while ((task = engine.getDelegatedTask()) != null) {
                            task.run();
                        }
                        continue block26;
                    }
                    case FINISHED: {
                        Logger.info("HandshakeFinished", new Object[0]);
                        continue block26;
                    }
                    case NOT_HANDSHAKING: {
                        Logger.info("NOT_HANDSHAKING", new Object[0]);
                        System.exit(-1);
                        continue block26;
                    }
                }
                throw new IllegalStateException("Invalid SSL status: " + (Object)((Object)handshakeStatus));
            }
            Logger.debug("\u63e1\u624b\u5b8c\u6bd5", new Object[0]);
            handshakeModel.getHandshakeCallback().callback();
        }
        catch (Exception e) {
            try {
                handshakeModel.getSslEngine().closeInbound();
            }
            catch (SSLException e1) {
                e1.printStackTrace();
            }
            handshakeModel.getSslEngine().closeOutbound();
            try {
                handshakeModel.getSocketChannel().close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            Logger.error("", e);
        }
    }

    protected ByteBuffer enlargePacketBuffer(SSLSession session, ByteBuffer buffer) {
        return this.enlargeBuffer(buffer, session.getPacketBufferSize());
    }

    protected ByteBuffer enlargeApplicationBuffer(SSLEngine engine, ByteBuffer buffer) {
        return this.enlargeBuffer(buffer, engine.getSession().getApplicationBufferSize());
    }

    protected ByteBuffer enlargeBuffer(ByteBuffer buffer, int sessionProposedCapacity) {
        buffer = sessionProposedCapacity > buffer.capacity() ? ByteBuffer.allocate(sessionProposedCapacity) : ByteBuffer.allocate(buffer.capacity() * 2);
        return buffer;
    }

    protected ByteBuffer handleBufferUnderflow(SSLSession session, ByteBuffer buffer) {
        if (session.getPacketBufferSize() < buffer.limit()) {
            return buffer;
        }
        ByteBuffer replaceBuffer = this.enlargePacketBuffer(session, buffer);
        buffer.flip();
        replaceBuffer.put(buffer);
        return replaceBuffer;
    }
}

