/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.spring.oauth;

import org.aoju.bus.oauth.metric.DefaultStateCache;
import org.aoju.bus.oauth.metric.StateCache;
import org.aoju.bus.spring.oauth.AuthProperties;
import org.aoju.bus.spring.oauth.AuthProviderService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@EnableConfigurationProperties(value={AuthProperties.class})
public class AuthConfiguration {
    @Bean
    public AuthProviderService authProviderFactory(AuthProperties properties, StateCache stateCache) {
        return new AuthProviderService(properties, stateCache);
    }

    @Bean
    @ConditionalOnMissingBean(value={StateCache.class})
    @ConditionalOnProperty(name={"extend.oauth.cache.type"}, havingValue="default", matchIfMissing=true)
    public StateCache stateCache() {
        return DefaultStateCache.INSTANCE;
    }
}

