/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.cache.support.cache;

import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.PreDestroy;
import org.aoju.bus.cache.support.cache.Cache;
import org.ehcache.PersistentCacheManager;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.ResourcePools;
import org.ehcache.config.ResourceUnit;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.config.units.EntryUnit;
import org.ehcache.config.units.MemoryUnit;

public class EhCache
implements Cache {
    private PersistentCacheManager cacheManager;
    private org.ehcache.Cache ehcache;

    public EhCache(long heapEntries, long offHeapMBSize, long diskGBSize) {
        this(heapEntries, offHeapMBSize, System.getProperty("user.home") + "/.EhCache", diskGBSize);
    }

    public EhCache(long heapEntries, long offHeapMBSize, String diskPath, long diskGBSize) {
        ResourcePools resourcePools = ResourcePoolsBuilder.newResourcePoolsBuilder().heap(heapEntries, (ResourceUnit)EntryUnit.ENTRIES).offheap(offHeapMBSize, MemoryUnit.MB).disk(diskGBSize, MemoryUnit.GB).build();
        CacheConfiguration configuration = CacheConfigurationBuilder.newCacheConfigurationBuilder(String.class, Serializable.class, (ResourcePools)resourcePools).build();
        this.cacheManager = (PersistentCacheManager)CacheManagerBuilder.newCacheManagerBuilder().with(CacheManagerBuilder.persistence((String)diskPath)).withCache("cache", configuration).build(true);
        this.ehcache = this.cacheManager.getCache("cache", String.class, Serializable.class);
    }

    @Override
    public Object read(String key) {
        return this.ehcache.get((Object)key);
    }

    @Override
    public void write(String key, Object value, long expire) {
        this.ehcache.put((Object)key, (Object)((Serializable)value));
    }

    @Override
    public Map<String, Object> read(Collection<String> keys) {
        HashMap<String, Object> map = new HashMap<String, Object>(keys.size());
        for (String key : keys) {
            map.put(key, this.ehcache.get((Object)key));
        }
        return map;
    }

    @Override
    public void write(Map<String, Object> keyValueMap, long expire) {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>(keyValueMap.size());
        for (Map.Entry<String, Object> entry : keyValueMap.entrySet()) {
            Object value = entry.getValue();
            map.put(entry.getKey(), (Serializable)value);
        }
        this.ehcache.putAll(map);
    }

    @Override
    public void remove(String ... keys) {
        this.ehcache.removeAll((Set)Sets.newHashSet((Object[])keys));
    }

    @Override
    public void clear() {
        this.ehcache.clear();
    }

    @PreDestroy
    public void tearDown() {
        if (this.cacheManager != null) {
            this.cacheManager.close();
        }
    }
}

