/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.io.segment;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.aoju.bus.core.io.segment.Buffer;
import org.aoju.bus.core.io.segment.ByteString;
import org.aoju.bus.core.io.segment.ForwardSource;
import org.aoju.bus.core.io.segment.Segment;
import org.aoju.bus.core.io.segment.Source;

public final class HashSource
extends ForwardSource {
    private final MessageDigest messageDigest;
    private final Mac mac;

    private HashSource(Source source, String algorithm) {
        super(source);
        try {
            this.messageDigest = MessageDigest.getInstance(algorithm);
            this.mac = null;
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError();
        }
    }

    private HashSource(Source source, ByteString key, String algorithm) {
        super(source);
        try {
            this.mac = Mac.getInstance(algorithm);
            this.mac.init(new SecretKeySpec(key.toByteArray(), algorithm));
            this.messageDigest = null;
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError();
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static HashSource md5(Source source) {
        return new HashSource(source, "MD5");
    }

    public static HashSource sha1(Source source) {
        return new HashSource(source, "SHA-1");
    }

    public static HashSource sha256(Source source) {
        return new HashSource(source, "SHA-256");
    }

    public static HashSource hmacSha1(Source source, ByteString key) {
        return new HashSource(source, key, "HmacSHA1");
    }

    public static HashSource hmacSha256(Source source, ByteString key) {
        return new HashSource(source, key, "HmacSHA256");
    }

    @Override
    public long read(Buffer sink, long byteCount) throws IOException {
        long result = super.read(sink, byteCount);
        if (result != -1L) {
            long offset;
            long start = sink.size - result;
            Segment s = sink.head;
            for (offset = sink.size; offset > start; offset -= (long)(s.limit - s.pos)) {
                s = s.prev;
            }
            while (offset < sink.size) {
                int pos = (int)((long)s.pos + start - offset);
                if (this.messageDigest != null) {
                    this.messageDigest.update(s.data, pos, s.limit - pos);
                } else {
                    this.mac.update(s.data, pos, s.limit - pos);
                }
                start = offset += (long)(s.limit - s.pos);
                s = s.next;
            }
        }
        return result;
    }

    public final ByteString hash() {
        byte[] result = this.messageDigest != null ? this.messageDigest.digest() : this.mac.doFinal();
        return ByteString.of(result);
    }
}

