/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.spring.sensitive;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.aoju.bus.base.spring.BaseAdvice;
import org.aoju.bus.core.consts.Charset;
import org.aoju.bus.core.utils.ArrayUtils;
import org.aoju.bus.core.utils.IoUtils;
import org.aoju.bus.core.utils.ObjectUtils;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.crypto.Builder;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.sensitive.annotation.Sensitive;
import org.aoju.bus.spring.sensitive.SensitiveProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.converter.HttpMessageConverter;

public class RequestBodyAdvice
extends BaseAdvice
implements org.springframework.web.servlet.mvc.method.annotation.RequestBodyAdvice {
    @Autowired
    SensitiveProperties properties;

    public boolean supports(MethodParameter parameter, Type type, Class<? extends HttpMessageConverter<?>> converterType) {
        Annotation[] annotations = parameter.getDeclaringClass().getAnnotations();
        if (ArrayUtils.isNotEmpty(annotations)) {
            for (Annotation annotation : annotations) {
                if (!(annotation instanceof Sensitive)) continue;
                return true;
            }
        }
        return parameter.getMethod().isAnnotationPresent(Sensitive.class);
    }

    public HttpInputMessage beforeBodyRead(HttpInputMessage inputMessage, MethodParameter parameter, Type type, Class<? extends HttpMessageConverter<?>> converterType) {
        if (ObjectUtils.isNotEmpty(this.properties) && !this.properties.isDebug()) {
            try {
                Sensitive sensitive = parameter.getMethod().getAnnotation(Sensitive.class);
                if (ObjectUtils.isEmpty(sensitive)) {
                    return inputMessage;
                }
                if ("ALL".equals(sensitive.value()) || "SAFE".equals(sensitive.value()) && ("ALL".equals(sensitive.stage()) || "IN".equals(sensitive.stage()))) {
                    inputMessage = new InputMessage(inputMessage, this.properties.getDecrypt().getKey(), this.properties.getDecrypt().getType(), "UTF-8");
                }
            }
            catch (Exception e) {
                Logger.error("Internal processing failure:" + e.getMessage(), new Object[0]);
            }
        }
        return inputMessage;
    }

    public Object afterBodyRead(Object body, HttpInputMessage inputMessage, MethodParameter parameter, Type type, Class<? extends HttpMessageConverter<?>> converterType) {
        return body;
    }

    public Object handleEmptyBody(Object body, HttpInputMessage inputMessage, MethodParameter parameter, Type type, Class<? extends HttpMessageConverter<?>> converterType) {
        return body;
    }

    class InputMessage
    implements HttpInputMessage {
        private HttpHeaders headers;
        private InputStream body;

        public InputMessage(HttpInputMessage inputMessage, String key, String type, String charset) throws Exception {
            String decryptBody;
            if (StringUtils.isEmpty(key)) {
                throw new NullPointerException("please check the request.crypto.decrypt");
            }
            this.headers = inputMessage.getHeaders();
            String content = IoUtils.toString(inputMessage.getBody(), charset);
            if (content.startsWith("{")) {
                decryptBody = content;
            } else {
                StringBuilder json = new StringBuilder();
                if (!StringUtils.isEmpty(content = content.replaceAll(" ", "+"))) {
                    String[] contents = content.split("\\|");
                    for (int k = 0; k < contents.length; ++k) {
                        json.append(Builder.decrypt(type, key, contents[k], Charset.UTF_8));
                    }
                }
                decryptBody = json.toString();
            }
            this.body = IoUtils.toInputStream(decryptBody, charset);
        }

        public InputStream getBody() {
            return this.body;
        }

        public HttpHeaders getHeaders() {
            return this.headers;
        }
    }
}

