/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.spring.wrapper;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.aoju.bus.core.utils.EscapeUtils;
import org.aoju.bus.core.utils.IoUtils;

public class RequestWrapper
extends HttpServletRequestWrapper {
    private static final byte[] DEFAULT_BYTE = new byte[0];
    private byte[] body;
    private ServletInputStreamWrapper inputStreamWrapper;

    RequestWrapper(HttpServletRequest request) throws IOException {
        super(request);
        this.body = IoUtils.readBytes((InputStream)request.getInputStream());
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.body != null ? this.body : DEFAULT_BYTE);
        this.inputStreamWrapper = new ServletInputStreamWrapper(byteArrayInputStream);
        this.inputStreamWrapper.setInputStream(byteArrayInputStream);
    }

    public byte[] getBody() {
        return this.body;
    }

    public ServletInputStream getInputStream() {
        return this.inputStreamWrapper;
    }

    public BufferedReader getReader() {
        return new BufferedReader(new InputStreamReader((InputStream)((Object)this.inputStreamWrapper)));
    }

    public String[] getParameterValues(String parameter) {
        String[] values = super.getParameterValues(parameter);
        if (values == null || values.length <= 0) {
            return null;
        }
        int count = values.length;
        String[] encodedValues = new String[count];
        for (int i = 0; i < count; ++i) {
            encodedValues[i] = EscapeUtils.escapeHtml4(values[i]);
        }
        return encodedValues;
    }

    public String getParameter(String parameter) {
        return EscapeUtils.escapeHtml4(super.getParameter(parameter));
    }

    public String getHeader(String name) {
        return EscapeUtils.escapeHtml4(super.getHeader(name));
    }

    private static class ServletInputStreamWrapper
    extends ServletInputStream {
        private InputStream inputStream;

        public boolean isFinished() {
            return true;
        }

        public boolean isReady() {
            return false;
        }

        public void setReadListener(ReadListener readListener) {
        }

        public int read() throws IOException {
            return this.inputStream.read();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ServletInputStreamWrapper)) {
                return false;
            }
            ServletInputStreamWrapper other = (ServletInputStreamWrapper)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            InputStream this$inputStream = this.getInputStream();
            InputStream other$inputStream = other.getInputStream();
            return !(this$inputStream == null ? other$inputStream != null : !this$inputStream.equals(other$inputStream));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ServletInputStreamWrapper;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            InputStream $inputStream = this.getInputStream();
            result = result * 59 + ($inputStream == null ? 43 : $inputStream.hashCode());
            return result;
        }

        public InputStream getInputStream() {
            return this.inputStream;
        }

        public void setInputStream(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        public String toString() {
            return "RequestWrapper.ServletInputStreamWrapper(inputStream=" + this.getInputStream() + ")";
        }

        public ServletInputStreamWrapper(InputStream inputStream) {
            this.inputStream = inputStream;
        }
    }
}

