/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.utils;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import org.aoju.bus.core.consts.Charset;
import org.aoju.bus.core.convert.Convert;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.ClassUtils;
import org.aoju.bus.core.utils.CollUtils;
import org.aoju.bus.core.utils.IoUtils;
import org.aoju.bus.core.utils.MapUtils;
import org.aoju.bus.core.utils.ResourceUtils;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.core.utils.TextUtils;

public class UriUtils {
    public static URL url(String url) {
        return UriUtils.url(url, null);
    }

    public static URL url(String url, URLStreamHandler handler) {
        Assert.notNull(url, "URL must not be null", new Object[0]);
        if (url.startsWith("classpath:")) {
            url = url.substring("classpath:".length());
            return ClassUtils.getClassLoader().getResource(url);
        }
        try {
            return new URL(null, url, handler);
        }
        catch (MalformedURLException e) {
            try {
                return new File(url).toURI().toURL();
            }
            catch (MalformedURLException ex2) {
                throw new InstrumentException(e);
            }
        }
    }

    public static URL toUrlForHttp(String urlStr) {
        return UriUtils.toUrlForHttp(urlStr, null);
    }

    public static URL toUrlForHttp(String urlStr, URLStreamHandler handler) {
        Assert.notBlank(urlStr, "Url is blank !", new Object[0]);
        urlStr = StringUtils.cleanBlank(urlStr);
        return UriUtils.url(urlStr, handler);
    }

    public static URL getURL(String pathBaseClassLoader) {
        return ResourceUtils.getResource(pathBaseClassLoader);
    }

    public static URL getURL(String path, Class<?> clazz) {
        return ResourceUtils.getResource(path, clazz);
    }

    public static URL getURL(File file) {
        Assert.notNull(file, "File is null !", new Object[0]);
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new InstrumentException("Error occured when get URL!");
        }
    }

    public static URL[] getURLs(File ... files) {
        URL[] urls = new URL[files.length];
        try {
            for (int i = 0; i < files.length; ++i) {
                urls[i] = files[i].toURI().toURL();
            }
        }
        catch (MalformedURLException e) {
            throw new InstrumentException("Error occured when get URL!");
        }
        return urls;
    }

    public static String formatUrl(String url) {
        return UriUtils.normalize(url);
    }

    public static String complateUrl(String baseUrl, String relativePath) {
        if (StringUtils.isBlank(baseUrl = UriUtils.formatUrl(baseUrl))) {
            return null;
        }
        try {
            URL absoluteUrl = new URL(baseUrl);
            URL parseUrl = new URL(absoluteUrl, relativePath);
            return parseUrl.toString();
        }
        catch (MalformedURLException e) {
            throw new InstrumentException(e);
        }
    }

    public static String encode(String url) throws InstrumentException {
        return UriUtils.encode(url, "UTF-8");
    }

    public static String encodeAll(String url) {
        return UriUtils.encodeAll(url, Charset.UTF_8);
    }

    public static String encodeAll(String url, java.nio.charset.Charset charset) {
        try {
            return URLEncoder.encode(url, charset.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new InstrumentException(e);
        }
    }

    public static String getPath(String uriStr) {
        URI uri;
        try {
            uri = new URI(uriStr);
        }
        catch (URISyntaxException e) {
            throw new InstrumentException(e);
        }
        return uri.getPath();
    }

    public static String getDecodedPath(URL url) {
        if (null == url) {
            return null;
        }
        String path = null;
        try {
            path = UriUtils.toURI(url).getPath();
        }
        catch (InstrumentException instrumentException) {
            // empty catch block
        }
        return null != path ? path : url.getPath();
    }

    public static URI toURI(URL url) throws InstrumentException {
        if (null == url) {
            return null;
        }
        try {
            return url.toURI();
        }
        catch (URISyntaxException e) {
            throw new InstrumentException(e);
        }
    }

    public static URI toURI(String location) throws InstrumentException {
        try {
            return new URI(location.replace(" ", "%20"));
        }
        catch (URISyntaxException e) {
            throw new InstrumentException(e);
        }
    }

    public static boolean isFileURL(URL url) {
        String protocol = url.getProtocol();
        return "file".equals(protocol) || "vfsfile".equals(protocol) || "vfs".equals(protocol);
    }

    public static boolean isJarURL(URL url) {
        String protocol = url.getProtocol();
        return "jar".equals(protocol) || "zip".equals(protocol) || "vfszip".equals(protocol) || "wsjar".equals(protocol);
    }

    public static boolean isJarFileURL(URL url) {
        return "file".equals(url.getProtocol()) && url.getPath().toLowerCase().endsWith(".jar");
    }

    public static InputStream getStream(URL url) {
        Assert.notNull(url);
        try {
            return url.openStream();
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static BufferedReader getReader(URL url, java.nio.charset.Charset charset) {
        return IoUtils.getReader(UriUtils.getStream(url), charset);
    }

    public static JarFile getJarFile(URL url) {
        try {
            JarURLConnection urlConnection = (JarURLConnection)url.openConnection();
            return urlConnection.getJarFile();
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static String normalize(String url) {
        String body;
        String pre;
        if (StringUtils.isBlank(url)) {
            return url;
        }
        int sepIndex = url.indexOf("://");
        if (sepIndex > 0) {
            pre = StringUtils.subPre(url, sepIndex + 3);
            body = StringUtils.subSuf(url, sepIndex + 3);
        } else {
            pre = "http://";
            body = url;
        }
        int paramsSepIndex = url.indexOf("?");
        String params = null;
        if (paramsSepIndex > 0) {
            params = StringUtils.subSuf(body, paramsSepIndex);
            body = StringUtils.subPre(body, paramsSepIndex);
        }
        body = body.replaceAll("^[\\/]+", "");
        body = body.replace("\\", "/").replaceAll("//+", "/");
        return pre + body + StringUtils.nullToEmpty(params);
    }

    public static String encodeScheme(String scheme, String encoding) {
        return UriUtils.encode(scheme, encoding, Type.SCHEME);
    }

    public static String encodeScheme(String scheme, java.nio.charset.Charset charset) {
        return UriUtils.encode(scheme, charset, Type.SCHEME);
    }

    public static String encodeAuthority(String authority, String encoding) {
        return UriUtils.encode(authority, encoding, Type.AUTHORITY);
    }

    public static String encodeAuthority(String authority, java.nio.charset.Charset charset) {
        return UriUtils.encode(authority, charset, Type.AUTHORITY);
    }

    public static String encodeUserInfo(String userInfo, String encoding) {
        return UriUtils.encode(userInfo, encoding, Type.USER_INFO);
    }

    public static String encodeUserInfo(String userInfo, java.nio.charset.Charset charset) {
        return UriUtils.encode(userInfo, charset, Type.USER_INFO);
    }

    public static String encodeHost(String host, String encoding) {
        return UriUtils.encode(host, encoding, Type.HOST_IPV4);
    }

    public static String encodeHost(String host, java.nio.charset.Charset charset) {
        return UriUtils.encode(host, charset, Type.HOST_IPV4);
    }

    public static String encodePort(String port, String encoding) {
        return UriUtils.encode(port, encoding, Type.PORT);
    }

    public static String encodePort(String port, java.nio.charset.Charset charset) {
        return UriUtils.encode(port, charset, Type.PORT);
    }

    public static String encodePath(String path, String encoding) {
        return UriUtils.encode(path, encoding, Type.PATH);
    }

    public static String encodePath(String path, java.nio.charset.Charset charset) {
        return UriUtils.encode(path, charset, Type.PATH);
    }

    public static String encodePathSegment(String segment, String encoding) {
        return UriUtils.encode(segment, encoding, Type.PATH_SEGMENT);
    }

    public static String encodePathSegment(String segment, java.nio.charset.Charset charset) {
        return UriUtils.encode(segment, charset, Type.PATH_SEGMENT);
    }

    public static String encodeQuery(String query, String encoding) {
        return UriUtils.encode(query, encoding, Type.QUERY);
    }

    public static String encodeQuery(String query, java.nio.charset.Charset charset) {
        return UriUtils.encode(query, charset, Type.QUERY);
    }

    public static String encodeQueryParam(String queryParam, String encoding) {
        return UriUtils.encode(queryParam, encoding, Type.QUERY_PARAM);
    }

    public static String encodeQueryParam(String queryParam, java.nio.charset.Charset charset) {
        return UriUtils.encode(queryParam, charset, Type.QUERY_PARAM);
    }

    public static String encodeFragment(String fragment, String encoding) {
        return UriUtils.encode(fragment, encoding, Type.FRAGMENT);
    }

    public static String encodeFragment(String fragment, java.nio.charset.Charset charset) {
        return UriUtils.encode(fragment, charset, Type.FRAGMENT);
    }

    public static String encode(String source, String encoding) {
        return UriUtils.encode(source, encoding, Type.URI);
    }

    public static String encode(String source, java.nio.charset.Charset charset) {
        return UriUtils.encode(source, charset, Type.URI);
    }

    public static Map<String, String> encodeUriVariables(Map<String, ?> uriVariables) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(uriVariables.size());
        for (Map.Entry<String, ?> entry : uriVariables.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            String stringValue = value != null ? value.toString() : "";
            result.put(key, UriUtils.encode(stringValue, java.nio.charset.Charset.forName("UTF-8")));
        }
        return result;
    }

    public static Object[] encodeUriVariables(Object ... uriVariables) {
        ArrayList<String> result = new ArrayList<String>();
        for (Object value : uriVariables) {
            String stringValue = value != null ? value.toString() : "";
            result.add(UriUtils.encode(stringValue, java.nio.charset.Charset.forName("UTF-8")));
        }
        return result.toArray();
    }

    private static String encode(String scheme, String encoding, Type type) {
        return UriUtils.encodeUriComponent(scheme, encoding, type);
    }

    private static String encode(String scheme, java.nio.charset.Charset charset, Type type) {
        return UriUtils.encodeUriComponent(scheme, charset, type);
    }

    static String encodeUriComponent(String source, String encoding, Type type) {
        return UriUtils.encodeUriComponent(source, java.nio.charset.Charset.forName(encoding), type);
    }

    static String encodeUriComponent(String source, java.nio.charset.Charset charset, Type type) {
        byte[] bytes;
        if (source == null || source.length() <= 0) {
            return source;
        }
        if (charset == null) {
            throw new IllegalArgumentException("Charset must not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Type must not be null");
        }
        try {
            bytes = source.getBytes(charset.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream(bytes.length);
        boolean changed = false;
        for (byte b : bytes) {
            if (b < 0) {
                b = (byte)(b + 256);
            }
            if (type.isAllowed(b)) {
                bos.write(b);
                continue;
            }
            bos.write(37);
            char hex1 = Character.toUpperCase(Character.forDigit(b >> 4 & 0xF, 16));
            char hex2 = Character.toUpperCase(Character.forDigit(b & 0xF, 16));
            bos.write(hex1);
            bos.write(hex2);
            changed = true;
        }
        try {
            return changed ? new String(bos.toByteArray(), charset.name()) : source;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String uriDecode(String source, java.nio.charset.Charset charset) {
        int length = source.length();
        if (length == 0) {
            return source;
        }
        if (charset == null) {
            throw new IllegalArgumentException("Charset must not be null");
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream(length);
        boolean changed = false;
        for (int i = 0; i < length; ++i) {
            char ch = source.charAt(i);
            if (ch == '%') {
                if (i + 2 < length) {
                    char hex1 = source.charAt(i + 1);
                    char hex2 = source.charAt(i + 2);
                    int u = Character.digit(hex1, 16);
                    int l = Character.digit(hex2, 16);
                    if (u == -1 || l == -1) {
                        throw new IllegalArgumentException("Invalid encoded sequence \"" + source.substring(i) + "\"");
                    }
                    bos.write((char)((u << 4) + l));
                    i += 2;
                    changed = true;
                    continue;
                }
                throw new IllegalArgumentException("Invalid encoded sequence \"" + source.substring(i) + "\"");
            }
            bos.write(ch);
        }
        try {
            return changed ? new String(bos.toByteArray(), charset.name()) : source;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String decode(String source, String encoding) {
        return UriUtils.uriDecode(source, java.nio.charset.Charset.forName(encoding));
    }

    public static String decode(String source, java.nio.charset.Charset charset) {
        return UriUtils.uriDecode(source, charset);
    }

    public static String extractFileExtension(String path) {
        int begin;
        int paramIndex;
        int extIndex;
        int end = path.indexOf(63);
        int fragmentIndex = path.indexOf(35);
        if (fragmentIndex != -1 && (end == -1 || fragmentIndex < end)) {
            end = fragmentIndex;
        }
        if (end == -1) {
            end = path.length();
        }
        if ((extIndex = path.lastIndexOf(46, end = (paramIndex = path.indexOf(59, begin = path.lastIndexOf(47, end) + 1)) != -1 && paramIndex < end ? paramIndex : end)) != -1 && extIndex > begin) {
            return path.substring(extIndex + 1, end);
        }
        return null;
    }

    public static String encodeVal(String paramsStr, java.nio.charset.Charset charset) {
        String paramPart;
        if (StringUtils.isBlank(paramsStr)) {
            return "";
        }
        String urlPart = null;
        int pathEndPos = paramsStr.indexOf(63);
        if (pathEndPos > -1) {
            urlPart = StringUtils.subPre(paramsStr, pathEndPos);
            paramPart = StringUtils.subSuf(paramsStr, pathEndPos + 1);
            if (StringUtils.isBlank(paramPart)) {
                return urlPart;
            }
        } else {
            paramPart = paramsStr;
        }
        paramPart = UriUtils.normalize(paramPart, charset);
        return StringUtils.isBlank(urlPart) ? paramPart : urlPart + "?" + paramPart;
    }

    public static String normalize(String paramPart, java.nio.charset.Charset charset) {
        int lastIndex;
        int i;
        TextUtils builder = TextUtils.create(paramPart.length() + 16);
        int len = paramPart.length();
        String name = null;
        int pos = 0;
        for (i = 0; i < len; ++i) {
            char c = paramPart.charAt(i);
            if (c == '=') {
                if (null != name) continue;
                name = pos == i ? "" : paramPart.substring(pos, i);
                pos = i + 1;
                continue;
            }
            if (c != '&') continue;
            if (pos != i) {
                if (null == name) {
                    name = paramPart.substring(pos, i);
                    builder.append(UriUtils.encodeQuery(name, charset)).append('=');
                } else {
                    builder.append(UriUtils.encodeQuery(name, charset)).append('=').append(UriUtils.encodeQuery(paramPart.substring(pos, i), charset)).append('&');
                }
                name = null;
            }
            pos = i + 1;
        }
        if (null != name) {
            builder.append(UriUtils.encodeQuery(name, charset)).append('=');
        }
        if (pos != i) {
            if (null == name && pos > 0) {
                builder.append('=');
            }
            builder.append(UriUtils.encodeQuery(paramPart.substring(pos, i), charset));
        }
        if ('&' == builder.charAt(lastIndex = builder.length() - 1)) {
            builder.delTo(lastIndex);
        }
        return builder.toString();
    }

    public static String decodeMap(Map<String, ?> paramMap, java.nio.charset.Charset charset) {
        if (CollUtils.isEmpty(paramMap)) {
            return "";
        }
        if (null == charset) {
            charset = Charset.UTF_8;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (Map.Entry<String, ?> item : paramMap.entrySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append("&");
            }
            String key = item.getKey();
            Object value = item.getValue();
            if (value instanceof Iterable) {
                value = CollUtils.join((Iterable)value, (CharSequence)",");
            } else if (value instanceof Iterator) {
                value = CollUtils.join((Iterator)value, (CharSequence)",");
            }
            String valueStr = Convert.toString(value);
            if (!StringUtils.isNotEmpty(key)) continue;
            sb.append(UriUtils.encodeAll(key, charset)).append("=");
            if (!StringUtils.isNotEmpty(valueStr)) continue;
            sb.append(UriUtils.encodeAll(valueStr, charset));
        }
        return sb.toString();
    }

    public static Map<String, String> decodeVal(String params, String charset) {
        Map<String, List<String>> paramsMap = UriUtils.decodeObj(params, charset);
        HashMap<String, String> result = MapUtils.newHashMap(paramsMap.size());
        for (Map.Entry<String, List<String>> entry : paramsMap.entrySet()) {
            List<String> list = entry.getValue();
            result.put(entry.getKey(), CollUtils.isEmpty(list) ? null : list.get(0));
        }
        return result;
    }

    public static Map<String, List<String>> decodeObj(String params, String charset) {
        int i;
        if (StringUtils.isBlank(params)) {
            return Collections.emptyMap();
        }
        int pathEndPos = params.indexOf(63);
        if (pathEndPos > -1) {
            params = StringUtils.subSuf(params, pathEndPos + 1);
        }
        LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>();
        int len = params.length();
        String name = null;
        int pos = 0;
        for (i = 0; i < len; ++i) {
            char c = params.charAt(i);
            if (c == '=') {
                if (null == name) {
                    name = params.substring(pos, i);
                }
                pos = i + 1;
                continue;
            }
            if (c != '&') continue;
            if (null == name && pos != i) {
                UriUtils.addParam(map, params.substring(pos, i), "", charset);
            } else if (name != null) {
                UriUtils.addParam(map, name, params.substring(pos, i), charset);
                name = null;
            }
            pos = i + 1;
        }
        if (pos != i) {
            if (name == null) {
                UriUtils.addParam(map, params.substring(pos, i), "", charset);
            } else {
                UriUtils.addParam(map, name, params.substring(pos, i), charset);
            }
        } else if (name != null) {
            UriUtils.addParam(map, name, "", charset);
        }
        return map;
    }

    public static String withForm(String url, Map<String, Object> form, java.nio.charset.Charset charset, boolean isEncodeParams) {
        if (isEncodeParams && StringUtils.contains(url, '?')) {
            url = UriUtils.encodeVal(url, charset);
        }
        return UriUtils.withForm(url, UriUtils.decodeMap(form, charset), charset, false);
    }

    public static String withForm(String url, String queryString, java.nio.charset.Charset charset, boolean isEncode) {
        if (StringUtils.isBlank(queryString)) {
            if (StringUtils.contains(url, '?')) {
                return isEncode ? UriUtils.encodeVal(url, charset) : url;
            }
            return url;
        }
        TextUtils textUtils = TextUtils.create(url.length() + queryString.length() + 16);
        int qmIndex = url.indexOf(63);
        if (qmIndex > 0) {
            textUtils.append(isEncode ? UriUtils.encodeVal(url, charset) : url);
            if (!StringUtils.endWith((CharSequence)url, '&')) {
                textUtils.append('&');
            }
        } else {
            textUtils.append(url);
            if (qmIndex < 0) {
                textUtils.append('?');
            }
        }
        textUtils.append(isEncode ? UriUtils.encodeVal(queryString, charset) : queryString);
        return textUtils.toString();
    }

    private static void addParam(Map<String, List<String>> params, String name, String value, String charset) {
        name = UriUtils.decode(name, charset);
        value = UriUtils.decode(value, charset);
        List<String> values = params.get(name);
        if (values == null) {
            values = new ArrayList<String>(1);
            params.put(name, values);
        }
        values.add(value);
    }

    public static enum Type {
        SCHEME{

            @Override
            public boolean isAllowed(int c) {
                return this.isAlpha(c) || this.isDigit(c) || 43 == c || 45 == c || 46 == c;
            }
        }
        ,
        AUTHORITY{

            @Override
            public boolean isAllowed(int c) {
                return this.isUnreserved(c) || this.isSubDelimiter(c) || 58 == c || 64 == c;
            }
        }
        ,
        USER_INFO{

            @Override
            public boolean isAllowed(int c) {
                return this.isUnreserved(c) || this.isSubDelimiter(c) || 58 == c;
            }
        }
        ,
        HOST_IPV4{

            @Override
            public boolean isAllowed(int c) {
                return this.isUnreserved(c) || this.isSubDelimiter(c);
            }
        }
        ,
        HOST_IPV6{

            @Override
            public boolean isAllowed(int c) {
                return this.isUnreserved(c) || this.isSubDelimiter(c) || 91 == c || 93 == c || 58 == c;
            }
        }
        ,
        PORT{

            @Override
            public boolean isAllowed(int c) {
                return this.isDigit(c);
            }
        }
        ,
        PATH{

            @Override
            public boolean isAllowed(int c) {
                return this.isPchar(c) || 47 == c;
            }
        }
        ,
        PATH_SEGMENT{

            @Override
            public boolean isAllowed(int c) {
                return this.isPchar(c);
            }
        }
        ,
        QUERY{

            @Override
            public boolean isAllowed(int c) {
                return this.isPchar(c) || 47 == c || 63 == c;
            }
        }
        ,
        QUERY_PARAM{

            @Override
            public boolean isAllowed(int c) {
                if (61 == c || 38 == c) {
                    return false;
                }
                return this.isPchar(c) || 47 == c || 63 == c;
            }
        }
        ,
        FRAGMENT{

            @Override
            public boolean isAllowed(int c) {
                return this.isPchar(c) || 47 == c || 63 == c;
            }
        }
        ,
        URI{

            @Override
            public boolean isAllowed(int c) {
                return this.isUnreserved(c);
            }
        };


        public abstract boolean isAllowed(int var1);

        protected boolean isAlpha(int c) {
            return c >= 97 && c <= 122 || c >= 65 && c <= 90;
        }

        protected boolean isDigit(int c) {
            return c >= 48 && c <= 57;
        }

        protected boolean isGenericDelimiter(int c) {
            return 58 == c || 47 == c || 63 == c || 35 == c || 91 == c || 93 == c || 64 == c;
        }

        protected boolean isSubDelimiter(int c) {
            return 33 == c || 36 == c || 38 == c || 39 == c || 40 == c || 41 == c || 42 == c || 43 == c || 44 == c || 59 == c || 61 == c;
        }

        protected boolean isReserved(int c) {
            return this.isGenericDelimiter(c) || this.isSubDelimiter(c);
        }

        protected boolean isUnreserved(int c) {
            return this.isAlpha(c) || this.isDigit(c) || 45 == c || 46 == c || 95 == c || 126 == c;
        }

        protected boolean isPchar(int c) {
            return this.isUnreserved(c) || this.isSubDelimiter(c) || 58 == c || 64 == c;
        }
    }
}

