/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.utils;

import java.beans.XMLDecoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.MapUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XmlUtils {
    public static Document readXML(InputStream inputStream) throws InstrumentException {
        return XmlUtils.readXML(new InputSource(inputStream));
    }

    public static Document readXML(Reader reader) throws InstrumentException {
        return XmlUtils.readXML(new InputSource(reader));
    }

    public static Document readXML(InputSource source) {
        DocumentBuilder builder = XmlUtils.createDocumentBuilder();
        try {
            return builder.parse(source);
        }
        catch (Exception e) {
            throw new InstrumentException("Parse XML from stream error!");
        }
    }

    public static <T> T readObjectFromXml(InputSource source) {
        Object result = null;
        try (XMLDecoder xmldec = null;){
            xmldec = new XMLDecoder(source);
            result = xmldec.readObject();
        }
        return (T)result;
    }

    public static Document createXml() {
        return XmlUtils.createDocumentBuilder().newDocument();
    }

    public static DocumentBuilder createDocumentBuilder() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        XmlUtils.disableXXE(dbf);
        DocumentBuilder builder = null;
        try {
            builder = dbf.newDocumentBuilder();
        }
        catch (Exception e) {
            throw new InstrumentException("Create xml document error!");
        }
        return builder;
    }

    public static Document createXml(String rootElementName) {
        Document doc = XmlUtils.createXml();
        doc.appendChild(doc.createElement(rootElementName));
        return doc;
    }

    public static Element getRootElement(Document doc) {
        return null == doc ? null : doc.getDocumentElement();
    }

    public static String cleanInvalid(String xmlContent) {
        if (xmlContent == null) {
            return null;
        }
        return xmlContent.replaceAll("[\\x00-\\x08\\x0b-\\x0c\\x0e-\\x1f]", "");
    }

    public static Element getElement(Element element, String tagName) {
        NodeList nodeList = element.getElementsByTagName(tagName);
        if (nodeList == null || nodeList.getLength() < 1) {
            return null;
        }
        int length = nodeList.getLength();
        for (int i = 0; i < length; ++i) {
            Element childEle = (Element)nodeList.item(i);
            if (childEle != null && childEle.getParentNode() != element) continue;
            return childEle;
        }
        return null;
    }

    public static String elementText(Element element, String tagName) {
        Element child = XmlUtils.getElement(element, tagName);
        return child == null ? null : child.getTextContent();
    }

    public static String elementText(Element element, String tagName, String defaultValue) {
        Element child = XmlUtils.getElement(element, tagName);
        return child == null ? defaultValue : child.getTextContent();
    }

    public static List<Element> transElements(NodeList nodeList) {
        return XmlUtils.transElements(null, nodeList);
    }

    public static List<Element> transElements(Element parentEle, NodeList nodeList) {
        int length = nodeList.getLength();
        ArrayList<Element> elements = new ArrayList<Element>(length);
        for (int i = 0; i < length; ++i) {
            Node node = nodeList.item(i);
            if (1 != node.getNodeType()) continue;
            Element element = (Element)nodeList.item(i);
            if (parentEle != null && element.getParentNode() != parentEle) continue;
            elements.add(element);
        }
        return elements;
    }

    public static XPath createXPath() {
        return XPathFactory.newInstance().newXPath();
    }

    public static Element getElementByXPath(String expression, Object source) {
        return (Element)XmlUtils.getNodeByXPath(expression, source);
    }

    public static NodeList getNodeListByXPath(String expression, Object source) {
        return (NodeList)XmlUtils.getByXPath(expression, source, XPathConstants.NODESET);
    }

    public static Node getNodeByXPath(String expression, Object source) {
        return (Node)XmlUtils.getByXPath(expression, source, XPathConstants.NODE);
    }

    public static Object getByXPath(String expression, Object source, QName returnType) {
        XPath xPath = XmlUtils.createXPath();
        try {
            if (source instanceof InputSource) {
                return xPath.evaluate(expression, (InputSource)source, returnType);
            }
            return xPath.evaluate(expression, source, returnType);
        }
        catch (XPathExpressionException e) {
            throw new InstrumentException(e);
        }
    }

    public static String escape(String string) {
        StringBuilder sb = new StringBuilder(string.length());
        int length = string.length();
        block7: for (int i = 0; i < length; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static Map<String, Object> xmlToMap(Node node) {
        return XmlUtils.xmlToMap(node, new HashMap<String, Object>());
    }

    public static Map<String, Object> xmlToMap(Node node, Map<String, Object> result) {
        if (null == result) {
            result = new HashMap<String, Object>();
        }
        NodeList nodeList = node.getChildNodes();
        int length = nodeList.getLength();
        for (int i = 0; i < length; ++i) {
            Node childNode = nodeList.item(i);
            if (!XmlUtils.isElement(childNode)) continue;
            Element childEle = (Element)childNode;
            result.put(childEle.getNodeName(), childEle.getTextContent());
        }
        return result;
    }

    public static Document mapToXml(Map<?, ?> data, String rootName) {
        Document doc = XmlUtils.createXml();
        Element root = XmlUtils.appendChild(doc, rootName);
        XmlUtils.mapToXml(doc, root, data);
        return doc;
    }

    public static boolean isElement(Node node) {
        return null != node && 1 == node.getNodeType();
    }

    public static Element appendChild(Node node, String tagName) {
        Document doc = node instanceof Document ? (Document)node : node.getOwnerDocument();
        Element child = doc.createElement(tagName);
        node.appendChild(child);
        return child;
    }

    private static void mapToXml(Document doc, Element element, Map<?, ?> data) {
        for (Map.Entry<?, ?> entry : data.entrySet()) {
            Element filedEle = doc.createElement(entry.getKey().toString());
            element.appendChild(filedEle);
            Object value = entry.getValue();
            if (value instanceof Map) {
                XmlUtils.mapToXml(doc, filedEle, (Map)value);
                element.appendChild(filedEle);
                continue;
            }
            filedEle.appendChild(doc.createTextNode(value.toString()));
        }
    }

    private static DocumentBuilderFactory disableXXE(DocumentBuilderFactory dbf) {
        try {
            String feature = "http://apache.org/xml/features/disallow-doctype-decl";
            dbf.setFeature(feature, true);
            feature = "http://xml.org/sax/features/external-general-entities";
            dbf.setFeature(feature, false);
            feature = "http://xml.org/sax/features/external-parameter-entities";
            dbf.setFeature(feature, false);
            feature = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
            dbf.setFeature(feature, false);
            dbf.setXIncludeAware(false);
            dbf.setExpandEntityReferences(false);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        return dbf;
    }

    public static Object parseXmlToBean(String text, Object javaBean) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{javaBean.getClass()});
            Unmarshaller um = jaxbContext.createUnmarshaller();
            return um.unmarshal((InputStream)new ByteArrayInputStream(text.getBytes(StandardCharsets.UTF_8)));
        }
        catch (JAXBException e) {
            throw new InstrumentException(e);
        }
    }

    public static Object parseXmlToBean(String text, Object javaBean, String charset) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{javaBean.getClass()});
            Unmarshaller um = jaxbContext.createUnmarshaller();
            return um.unmarshal((InputStream)new ByteArrayInputStream(text.getBytes(charset)));
        }
        catch (UnsupportedEncodingException | JAXBException e) {
            throw new InstrumentException(e);
        }
    }

    public static Object convertXmlStrToObject(String xml, Class clazz) {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{clazz});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            StringReader sr = new StringReader(xml);
            return unmarshaller.unmarshal((Reader)sr);
        }
        catch (JAXBException e) {
            throw new InstrumentException(e);
        }
    }

    public static <T> List<T> parseXmlToBeanList(String xml, String rel, Class<T> clazz, boolean isSelect) {
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
            Unmarshaller um = jaxbContext.createUnmarshaller();
            if (xml != null && xml.contains(rel)) {
                String[] entrys;
                String start_tag = "<" + rel + ">";
                if (isSelect) {
                    start_tag = "<" + rel + " action=\"select\">";
                }
                String end_tag = "</" + rel + ">";
                for (String val : entrys = xml.split(end_tag)) {
                    if (null == val || !val.contains(start_tag)) continue;
                    String once = val.substring(val.indexOf(start_tag)) + end_tag;
                    Object ob = um.unmarshal((InputStream)new ByteArrayInputStream(once.getBytes(StandardCharsets.UTF_8)));
                    list.add(ob);
                }
            }
            return list;
        }
        catch (JAXBException e) {
            throw new InstrumentException(e);
        }
    }

    public static <T> List<T> parseXmlToBeanList(String xml, String rel, Class<T> clazz) {
        return XmlUtils.parseXmlToBeanList(xml, rel, clazz, true);
    }

    public static String parseBeanToXml(Object object) throws Exception {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{object.getClass()});
        Marshaller m = context.createMarshaller();
        StringWriter sw = new StringWriter();
        m.marshal(object, (Writer)sw);
        return sw.toString();
    }

    public static String parseBeanToXml(Object object, Map<String, Object> map, Marshaller.Listener listener) throws Exception {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{object.getClass()});
        Marshaller marshaller = context.createMarshaller();
        if (MapUtils.isNotEmpty(map)) {
            map.forEach((key, value) -> {
                try {
                    marshaller.setProperty(key, value);
                }
                catch (PropertyException e) {
                    throw new InstrumentException(e);
                }
            });
        }
        if (Objects.nonNull(listener)) {
            marshaller.setListener(listener);
        }
        StringWriter sw = new StringWriter();
        marshaller.marshal(object, (Writer)sw);
        return sw.toString();
    }

    public static String replaceEscapeCharacter(String xml) {
        return xml.replaceAll("&lt;", "<").replaceAll("&gt;", ">").replaceAll("&quot;", "\"");
    }

    public static String mapToXmlNosign(Map<String, Object> map) {
        StringBuffer sb = new StringBuffer();
        Set<String> set = map.keySet();
        for (String key : set) {
            String value;
            String string = value = null != map.get(key) ? map.get(key) : " ";
            if ("sign".equals(key)) continue;
            sb.append("<" + key + ">" + value + "</" + key + ">");
        }
        return sb.toString();
    }

    public static <T> List<T> XMLToBeanList(String xml, String rel, Class<T> clazz) {
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
            Unmarshaller um = jaxbContext.createUnmarshaller();
            if (xml != null && xml.contains(rel)) {
                String[] entrys;
                String start_tag = "<" + rel + ">";
                String end_tag = "</" + rel + ">";
                for (String val : entrys = xml.split(end_tag)) {
                    if (null == val || !val.contains(start_tag)) continue;
                    String once = val.substring(val.indexOf(start_tag)) + end_tag;
                    Object ob = um.unmarshal((Reader)new StringReader(once));
                    list.add(ob);
                }
            }
        }
        catch (JAXBException e) {
            throw new InstrumentException(e);
        }
        return list;
    }

    public static String xmlToLowerCase(String xml) {
        Pattern pattern = Pattern.compile("<.+?>");
        StringBuilder res = new StringBuilder();
        int lastIdx = 0;
        Matcher matchr = pattern.matcher(xml);
        while (matchr.find()) {
            String str = matchr.group();
            res.append(xml, lastIdx, matchr.start());
            res.append(str.toLowerCase());
            lastIdx = matchr.end();
        }
        res.append(xml.substring(lastIdx));
        return res.toString();
    }

    public static String getFieldByxml(String xml, String field) {
        return new XmlUtils().getfield(xml, field);
    }

    public String requestModel(Object esbEntry) throws JAXBException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{esbEntry.getClass()});
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.marshal(esbEntry, (OutputStream)byteArrayOutputStream);
        String xmlContent = new String(byteArrayOutputStream.toByteArray(), StandardCharsets.UTF_8);
        return xmlContent.replace("&lt;", "<").replace("&gt;", ">").replace("&quot;", "\"");
    }

    public String getfield(String str, String field) {
        String[] entrys;
        String s1 = str.replace("<map>", "");
        String s2 = s1.replace("</map>", "");
        for (String s : entrys = s2.split("</entry>")) {
            if (!s.contains(field)) continue;
            return s.substring(s.indexOf(">") + 1);
        }
        return "";
    }
}

