/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.http;

import java.net.InetSocketAddress;
import java.net.Proxy;
import org.aoju.bus.http.Request;
import org.aoju.bus.http.Response;
import org.aoju.bus.http.Route;
import org.aoju.bus.http.offers.Authenticator;
import org.aoju.bus.http.offers.Credentials;

public class Proxy {
    public final String hostAddress;
    public final int port;
    public final String user;
    public final String password;
    public final Proxy.Type type;

    public Proxy(String hostAddress, int port, String user, String password, Proxy.Type type) {
        this.hostAddress = hostAddress;
        this.port = port;
        this.user = user;
        this.password = password;
        this.type = type;
    }

    public Proxy(String hostAddress, int port) {
        this(hostAddress, port, null, null, Proxy.Type.HTTP);
    }

    java.net.Proxy proxy() {
        return new java.net.Proxy(this.type, new InetSocketAddress(this.hostAddress, this.port));
    }

    Authenticator authenticator() {
        return new Authenticator(){

            @Override
            public Request authenticate(Route route, Response response) {
                String credential = Credentials.basic(Proxy.this.user, Proxy.this.password);
                return response.request().newBuilder().header("Proxy-Authorization", credential).header("Proxy-Connection", "Keep-Alive").build();
            }
        };
    }
}

