/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.mapper.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.aoju.bus.mapper.MapperException;
import org.aoju.bus.mapper.criteria.Assert;
import org.aoju.bus.mapper.criteria.Identity;
import org.aoju.bus.mapper.criteria.SimpleType;
import org.aoju.bus.mapper.criteria.Style;

public class Config {
    public static final String PREFIX = "mapper";
    private List<Class> mappers = new ArrayList<Class>();
    private String UUID;
    private String identity;
    private String seqFormat;
    private String catalog;
    private String schema;
    private boolean BEFORE;
    private boolean checkEntityClass;
    private boolean useSimpleType = true;
    private boolean enumAsSimpleType;
    private boolean enableMethodAnnotation;
    private boolean notEmpty;
    private Style style;
    private String wrapKeyword = "";

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public String getIdentity() {
        if (Assert.isNotEmpty(this.identity)) {
            return this.identity;
        }
        return Identity.MYSQL.getIdentityRetrievalStatement();
    }

    public void setIdentity(String IDENTITY) {
        Identity identity = Identity.getDatabaseDialect(IDENTITY);
        this.identity = identity != null ? identity.getIdentityRetrievalStatement() : IDENTITY;
    }

    public String getPrefix() {
        if (Assert.isNotEmpty(this.catalog)) {
            return this.catalog;
        }
        if (Assert.isNotEmpty(this.schema)) {
            return this.schema;
        }
        return "";
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getSeqFormat() {
        if (Assert.isNotEmpty(this.seqFormat)) {
            return this.seqFormat;
        }
        return "{0}.nextval";
    }

    public void setSeqFormat(String seqFormat) {
        this.seqFormat = seqFormat;
    }

    public Style getStyle() {
        return this.style == null ? Style.camelhump : this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public String getUUID() {
        if (Assert.isNotEmpty(this.UUID)) {
            return this.UUID;
        }
        return "@java.util.UUID@randomUUID().toString().replace(\"-\", \"\")";
    }

    public void setUUID(String UUID2) {
        this.UUID = UUID2;
    }

    public String getWrapKeyword() {
        return this.wrapKeyword;
    }

    public void setWrapKeyword(String wrapKeyword) {
        this.wrapKeyword = wrapKeyword;
    }

    public boolean isBEFORE() {
        return this.BEFORE;
    }

    public void setBEFORE(boolean BEFORE) {
        this.BEFORE = BEFORE;
    }

    public boolean isCheckEntityClass() {
        return this.checkEntityClass;
    }

    public void setCheckEntityClass(boolean checkEntityClass) {
        this.checkEntityClass = checkEntityClass;
    }

    public boolean isEnableMethodAnnotation() {
        return this.enableMethodAnnotation;
    }

    public void setEnableMethodAnnotation(boolean enableMethodAnnotation) {
        this.enableMethodAnnotation = enableMethodAnnotation;
    }

    public boolean isEnumAsSimpleType() {
        return this.enumAsSimpleType;
    }

    public void setEnumAsSimpleType(boolean enumAsSimpleType) {
        this.enumAsSimpleType = enumAsSimpleType;
    }

    public boolean isNotEmpty() {
        return this.notEmpty;
    }

    public void setNotEmpty(boolean notEmpty) {
        this.notEmpty = notEmpty;
    }

    public boolean isUseSimpleType() {
        return this.useSimpleType;
    }

    public void setUseSimpleType(boolean useSimpleType) {
        this.useSimpleType = useSimpleType;
    }

    public void setOrder(String order) {
        this.BEFORE = "BEFORE".equalsIgnoreCase(order);
    }

    public List<Class> getMappers() {
        return this.mappers;
    }

    public void setMappers(List<Class> mappers) {
        this.mappers = mappers;
    }

    public String getUuid() {
        return this.getUUID();
    }

    public void setUuid(String uuid) {
        this.setUUID(uuid);
    }

    public boolean isBefore() {
        return this.isBEFORE();
    }

    public void setBefore(boolean before) {
        this.setBEFORE(before);
    }

    public void setProperties(Properties properties) {
        String styleStr;
        String ORDER;
        String schema;
        String catalog;
        String seqFormat;
        String identity;
        if (properties == null) {
            this.style = Style.camelhump;
            return;
        }
        String UUID2 = properties.getProperty("UUID");
        if (Assert.isNotEmpty(UUID2)) {
            this.setUUID(UUID2);
        }
        if (Assert.isNotEmpty(identity = properties.getProperty("IDENTITY"))) {
            this.setIdentity(identity);
        }
        if (Assert.isNotEmpty(seqFormat = properties.getProperty("seqFormat"))) {
            this.setSeqFormat(seqFormat);
        }
        if (Assert.isNotEmpty(catalog = properties.getProperty("catalog"))) {
            this.setCatalog(catalog);
        }
        if (Assert.isNotEmpty(schema = properties.getProperty("schema"))) {
            this.setSchema(schema);
        }
        if (Assert.isNotEmpty(ORDER = properties.getProperty("ORDER"))) {
            this.setOrder(ORDER);
        }
        this.notEmpty = Boolean.valueOf(properties.getProperty("notEmpty"));
        this.enableMethodAnnotation = Boolean.valueOf(properties.getProperty("enableMethodAnnotation"));
        this.checkEntityClass = Boolean.valueOf(properties.getProperty("checkEntityClass"));
        String useSimpleTypeStr = properties.getProperty("useSimpleType");
        if (Assert.isNotEmpty(useSimpleTypeStr)) {
            this.useSimpleType = Boolean.valueOf(useSimpleTypeStr);
        }
        this.enumAsSimpleType = Boolean.valueOf(properties.getProperty("enumAsSimpleType"));
        String simpleTypes = properties.getProperty("simpleTypes");
        if (Assert.isNotEmpty(simpleTypes)) {
            SimpleType.registerSimpleType(simpleTypes);
        }
        if (Assert.isNotEmpty(styleStr = properties.getProperty("style"))) {
            try {
                this.style = Style.valueOf(styleStr);
            }
            catch (IllegalArgumentException e) {
                throw new MapperException(styleStr + "\u4e0d\u662f\u5408\u6cd5\u7684Style\u503c!");
            }
        } else {
            this.style = Style.camelhump;
        }
        String wrapKeyword = properties.getProperty("wrapKeyword");
        if (Assert.isNotEmpty(wrapKeyword)) {
            this.wrapKeyword = wrapKeyword;
        }
    }
}

