/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.oauth.provider;

import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import org.aoju.bus.core.consts.Normal;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.oauth.Context;
import org.aoju.bus.oauth.Registry;
import org.aoju.bus.oauth.magic.AccToken;
import org.aoju.bus.oauth.magic.Callback;
import org.aoju.bus.oauth.magic.Property;
import org.aoju.bus.oauth.metric.StateCache;
import org.aoju.bus.oauth.provider.DefaultProvider;

public class GithubProvider
extends DefaultProvider {
    public GithubProvider(Context context) {
        super(context, Registry.GITHUB);
    }

    public GithubProvider(Context context, StateCache stateCache) {
        super(context, Registry.GITHUB, stateCache);
    }

    @Override
    protected AccToken getAccessToken(Callback Callback2) {
        Map<String, String> res = GithubProvider.parseStringToMap(this.doPostAuthorizationCode(Callback2.getCode()));
        this.checkResponse(res.containsKey("error"), res.get("error_description"));
        return AccToken.builder().accessToken(res.get("access_token")).scope(res.get("scope")).tokenType(res.get("token_type")).build();
    }

    @Override
    protected Property getUserInfo(AccToken token) {
        JSONObject object = JSONObject.parseObject((String)this.doGetUserInfo(token));
        this.checkResponse(object.containsKey((Object)"error"), object.getString("error_description"));
        return Property.builder().uuid(object.getString("id")).username(object.getString("login")).avatar(object.getString("avatar_url")).blog(object.getString("blog")).nickname(object.getString("name")).company(object.getString("company")).location(object.getString("location")).email(object.getString("email")).remark(object.getString("bio")).gender(Normal.Gender.UNKNOWN).token(token).source(this.source.toString()).build();
    }

    private void checkResponse(boolean error, String error_description) {
        if (error) {
            throw new InstrumentException(error_description);
        }
    }
}

