/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.validate.strategy;

import java.lang.reflect.Method;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.lang.exception.NoSuchException;
import org.aoju.bus.core.utils.ClassUtils;
import org.aoju.bus.core.utils.ObjectUtils;
import org.aoju.bus.core.utils.ReflectUtils;
import org.aoju.bus.validate.Context;
import org.aoju.bus.validate.Registry;
import org.aoju.bus.validate.annotation.Reflect;
import org.aoju.bus.validate.validators.Complex;

public class ReflectStrategy
implements Complex<Object, Reflect> {
    @Override
    public boolean on(Object object, Reflect annotation, Context context) {
        Object result;
        if (ObjectUtils.isEmpty(object)) {
            return true;
        }
        Class<?> clazz = annotation.target();
        String methodName = annotation.method();
        try {
            Method method = clazz.getDeclaredMethod(methodName, object.getClass());
            Class<Class<?>> bean = ClassUtils.getClass(clazz);
            result = ReflectUtils.invokeMethod(method, bean);
        }
        catch (NoSuchMethodException e) {
            throw new InstrumentException(e.getMessage(), e);
        }
        for (String name : annotation.validator()) {
            if (!Registry.getInstance().contains(name)) {
                throw new NoSuchException("\u5c1d\u8bd5\u4f7f\u7528\u4e00\u4e2a\u4e0d\u5b58\u5728\u7684\u6821\u9a8c\u5668\uff1a" + name);
            }
            Complex complex = (Complex)Registry.getInstance().require(name);
            if (complex.on(result, null, context)) continue;
            return false;
        }
        return true;
    }
}

