/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.convert.impl;

import java.lang.reflect.Type;
import java.util.Map;
import org.aoju.bus.core.convert.AbstractConverter;
import org.aoju.bus.core.convert.ConverterRegistry;
import org.aoju.bus.core.utils.BeanUtils;
import org.aoju.bus.core.utils.MapUtils;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.core.utils.TypeUtils;

public class MapConverter
extends AbstractConverter<Map<?, ?>> {
    private final Type mapType;
    private final Type keyType;
    private final Type valueType;

    public MapConverter(Type mapType) {
        this(mapType, TypeUtils.getTypeArgument(mapType, 0), TypeUtils.getTypeArgument(mapType, 1));
    }

    public MapConverter(Type mapType, Type keyType, Type valueType) {
        this.mapType = mapType;
        this.keyType = keyType;
        this.valueType = valueType;
    }

    @Override
    protected Map<?, ?> convertInternal(Object value) {
        Map<Object, Object> map = null;
        if (value instanceof Map) {
            map = MapUtils.createMap(TypeUtils.getClass(this.mapType));
            this.convertMapToMap((Map)value, map);
        } else if (BeanUtils.isBean(value.getClass())) {
            map = BeanUtils.beanToMap(value);
        } else {
            throw new UnsupportedOperationException(StringUtils.format("Unsupport toMap value type: {}", value.getClass().getName()));
        }
        return map;
    }

    private void convertMapToMap(Map<?, ?> srcMap, Map<Object, Object> targetMap) {
        ConverterRegistry convert = ConverterRegistry.getInstance();
        for (Map.Entry<?, ?> entry : srcMap.entrySet()) {
            Object key = null == this.keyType ? entry.getKey() : convert.convert(this.keyType, entry.getKey());
            Object value = null == this.valueType ? entry.getValue() : convert.convert(this.keyType, entry.getValue());
            targetMap.put(key, value);
        }
    }

    @Override
    public Class<Map<?, ?>> getTargetType() {
        return TypeUtils.getClass(this.mapType);
    }
}

