/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.http;

import java.net.Proxy;
import java.net.ProxySelector;
import java.util.List;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import org.aoju.bus.http.Internal;
import org.aoju.bus.http.Protocol;
import org.aoju.bus.http.Url;
import org.aoju.bus.http.accord.ConnectionSpec;
import org.aoju.bus.http.offers.Authenticator;
import org.aoju.bus.http.offers.CertificatePinner;
import org.aoju.bus.http.offers.Dns;

public final class Address {
    public final Url url;
    public final Dns dns;
    public final SocketFactory socketFactory;
    public final Authenticator proxyAuthenticator;
    public final List<Protocol> protocols;
    public final List<ConnectionSpec> connectionSpecs;
    public final ProxySelector proxySelector;
    public final Proxy proxy;
    public final SSLSocketFactory sslSocketFactory;
    public final HostnameVerifier hostnameVerifier;
    public final CertificatePinner certificatePinner;

    public Address(String uriHost, int uriPort, Dns dns, SocketFactory socketFactory, SSLSocketFactory sslSocketFactory, HostnameVerifier hostnameVerifier, CertificatePinner certificatePinner, Authenticator proxyAuthenticator, Proxy proxy, List<Protocol> protocols, List<ConnectionSpec> connectionSpecs, ProxySelector proxySelector) {
        this.url = new Url.Builder().scheme(sslSocketFactory != null ? "https" : "http").host(uriHost).port(uriPort).build();
        if (dns == null) {
            throw new NullPointerException("dns == null");
        }
        this.dns = dns;
        if (socketFactory == null) {
            throw new NullPointerException("socketFactory == null");
        }
        this.socketFactory = socketFactory;
        if (proxyAuthenticator == null) {
            throw new NullPointerException("proxyAuthenticator == null");
        }
        this.proxyAuthenticator = proxyAuthenticator;
        if (protocols == null) {
            throw new NullPointerException("protocols == null");
        }
        this.protocols = Internal.immutableList(protocols);
        if (connectionSpecs == null) {
            throw new NullPointerException("connectionSpecs == null");
        }
        this.connectionSpecs = Internal.immutableList(connectionSpecs);
        if (proxySelector == null) {
            throw new NullPointerException("proxySelector == null");
        }
        this.proxySelector = proxySelector;
        this.proxy = proxy;
        this.sslSocketFactory = sslSocketFactory;
        this.hostnameVerifier = hostnameVerifier;
        this.certificatePinner = certificatePinner;
    }

    public Url url() {
        return this.url;
    }

    public Dns dns() {
        return this.dns;
    }

    public SocketFactory socketFactory() {
        return this.socketFactory;
    }

    public Authenticator proxyAuthenticator() {
        return this.proxyAuthenticator;
    }

    public List<Protocol> protocols() {
        return this.protocols;
    }

    public List<ConnectionSpec> connectionSpecs() {
        return this.connectionSpecs;
    }

    public ProxySelector proxySelector() {
        return this.proxySelector;
    }

    public Proxy proxy() {
        return this.proxy;
    }

    public SSLSocketFactory sslSocketFactory() {
        return this.sslSocketFactory;
    }

    public HostnameVerifier hostnameVerifier() {
        return this.hostnameVerifier;
    }

    public CertificatePinner certificatePinner() {
        return this.certificatePinner;
    }

    public boolean equals(Object other) {
        return other instanceof Address && this.url.equals(((Address)other).url) && this.equalsNonHost((Address)other);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.url.hashCode();
        result = 31 * result + this.dns.hashCode();
        result = 31 * result + this.proxyAuthenticator.hashCode();
        result = 31 * result + this.protocols.hashCode();
        result = 31 * result + this.connectionSpecs.hashCode();
        result = 31 * result + this.proxySelector.hashCode();
        result = 31 * result + (this.proxy != null ? this.proxy.hashCode() : 0);
        result = 31 * result + (this.sslSocketFactory != null ? this.sslSocketFactory.hashCode() : 0);
        result = 31 * result + (this.hostnameVerifier != null ? this.hostnameVerifier.hashCode() : 0);
        result = 31 * result + (this.certificatePinner != null ? this.certificatePinner.hashCode() : 0);
        return result;
    }

    public boolean equalsNonHost(Address that) {
        return this.dns.equals(that.dns) && this.proxyAuthenticator.equals(that.proxyAuthenticator) && this.protocols.equals(that.protocols) && this.connectionSpecs.equals(that.connectionSpecs) && this.proxySelector.equals(that.proxySelector) && Internal.equal(this.proxy, that.proxy) && Internal.equal(this.sslSocketFactory, that.sslSocketFactory) && Internal.equal(this.hostnameVerifier, that.hostnameVerifier) && Internal.equal(this.certificatePinner, that.certificatePinner) && this.url().port() == that.url().port();
    }

    public String toString() {
        StringBuilder result = new StringBuilder().append("Address{").append(this.url.host()).append(":").append(this.url.port());
        if (this.proxy != null) {
            result.append(", proxy=").append(this.proxy);
        } else {
            result.append(", proxySelector=").append(this.proxySelector);
        }
        result.append("}");
        return result.toString();
    }
}

