/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.oauth;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.aoju.bus.core.consts.Charset;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.CollUtils;
import org.aoju.bus.core.utils.MapUtils;
import org.aoju.bus.core.utils.ObjectUtils;
import org.aoju.bus.core.utils.StringUtils;

public class Builder {
    private final Map<String, Object> params = new LinkedHashMap<String, Object>(7);
    private String baseUrl;

    private Builder() {
    }

    public static Builder fromBaseUrl(String baseUrl) {
        Builder builder = new Builder();
        builder.setBaseUrl(baseUrl);
        return builder;
    }

    public static String appendIfNotContain(String str, String appendStr, String otherwise) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(appendStr)) {
            return str;
        }
        if (str.contains(appendStr)) {
            return str.concat(otherwise);
        }
        return str.concat(appendStr);
    }

    public static String parseMapToString(Map<String, Object> params, boolean encode) {
        ArrayList paramList = new ArrayList();
        params.forEach((k, v) -> {
            if (ObjectUtils.isNull(v)) {
                paramList.add(k + "=");
            } else {
                String valueString = v.toString();
                paramList.add(k + "=" + (encode ? Builder.encode(valueString) : valueString));
            }
        });
        return CollUtils.join(paramList, (CharSequence)"&");
    }

    public static String encode(String value) {
        if (value == null) {
            return "";
        }
        try {
            String encoded = URLEncoder.encode(value, Charset.UTF_8.displayName());
            return encoded.replace("+", "%20").replace("*", "%2A").replace("~", "%7E").replace("/", "%2F");
        }
        catch (UnsupportedEncodingException e) {
            throw new InstrumentException("Failed To Encode Uri", e);
        }
    }

    public Builder queryParam(String key, Object value) {
        Assert.notBlank(key, "\u53c2\u6570\u540d\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        String valueAsString = value != null ? value.toString() : null;
        this.params.put(key, valueAsString);
        return this;
    }

    public String build() {
        return this.build(false);
    }

    public String build(boolean encode) {
        if (MapUtils.isEmpty(this.params)) {
            return this.baseUrl;
        }
        String baseUrl = Builder.appendIfNotContain(this.baseUrl, "?", "&");
        String paramString = Builder.parseMapToString(this.params, encode);
        return baseUrl + paramString;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public static class Token {
        private int expireIn;
        private String accessToken;
        private String refreshToken;
        private String uid;
        private String openId;
        private String accessCode;
        private String unionId;
        private String scope;
        private String tokenType;
        private String idToken;
        private String macAlgorithm;
        private String macKey;
        private String code;

        Token(int expireIn, String accessToken, String refreshToken, String uid, String openId, String accessCode, String unionId, String scope, String tokenType, String idToken, String macAlgorithm, String macKey, String code) {
            this.expireIn = expireIn;
            this.accessToken = accessToken;
            this.refreshToken = refreshToken;
            this.uid = uid;
            this.openId = openId;
            this.accessCode = accessCode;
            this.unionId = unionId;
            this.scope = scope;
            this.tokenType = tokenType;
            this.idToken = idToken;
            this.macAlgorithm = macAlgorithm;
            this.macKey = macKey;
            this.code = code;
        }

        public static TokenBuilder builder() {
            return new TokenBuilder();
        }

        public int getExpireIn() {
            return this.expireIn;
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        public String getRefreshToken() {
            return this.refreshToken;
        }

        public String getUid() {
            return this.uid;
        }

        public String getOpenId() {
            return this.openId;
        }

        public String getAccessCode() {
            return this.accessCode;
        }

        public String getUnionId() {
            return this.unionId;
        }

        public String getScope() {
            return this.scope;
        }

        public String getTokenType() {
            return this.tokenType;
        }

        public String getIdToken() {
            return this.idToken;
        }

        public String getMacAlgorithm() {
            return this.macAlgorithm;
        }

        public String getMacKey() {
            return this.macKey;
        }

        public String getCode() {
            return this.code;
        }

        public void setExpireIn(int expireIn) {
            this.expireIn = expireIn;
        }

        public void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        public void setRefreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
        }

        public void setUid(String uid) {
            this.uid = uid;
        }

        public void setOpenId(String openId) {
            this.openId = openId;
        }

        public void setAccessCode(String accessCode) {
            this.accessCode = accessCode;
        }

        public void setUnionId(String unionId) {
            this.unionId = unionId;
        }

        public void setScope(String scope) {
            this.scope = scope;
        }

        public void setTokenType(String tokenType) {
            this.tokenType = tokenType;
        }

        public void setIdToken(String idToken) {
            this.idToken = idToken;
        }

        public void setMacAlgorithm(String macAlgorithm) {
            this.macAlgorithm = macAlgorithm;
        }

        public void setMacKey(String macKey) {
            this.macKey = macKey;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public static class TokenBuilder {
            private int expireIn;
            private String accessToken;
            private String refreshToken;
            private String uid;
            private String openId;
            private String accessCode;
            private String unionId;
            private String scope;
            private String tokenType;
            private String idToken;
            private String macAlgorithm;
            private String macKey;
            private String code;

            TokenBuilder() {
            }

            public TokenBuilder expireIn(int expireIn) {
                this.expireIn = expireIn;
                return this;
            }

            public TokenBuilder accessToken(String accessToken) {
                this.accessToken = accessToken;
                return this;
            }

            public TokenBuilder refreshToken(String refreshToken) {
                this.refreshToken = refreshToken;
                return this;
            }

            public TokenBuilder uid(String uid) {
                this.uid = uid;
                return this;
            }

            public TokenBuilder openId(String openId) {
                this.openId = openId;
                return this;
            }

            public TokenBuilder accessCode(String accessCode) {
                this.accessCode = accessCode;
                return this;
            }

            public TokenBuilder unionId(String unionId) {
                this.unionId = unionId;
                return this;
            }

            public TokenBuilder scope(String scope) {
                this.scope = scope;
                return this;
            }

            public TokenBuilder tokenType(String tokenType) {
                this.tokenType = tokenType;
                return this;
            }

            public TokenBuilder idToken(String idToken) {
                this.idToken = idToken;
                return this;
            }

            public TokenBuilder macAlgorithm(String macAlgorithm) {
                this.macAlgorithm = macAlgorithm;
                return this;
            }

            public TokenBuilder macKey(String macKey) {
                this.macKey = macKey;
                return this;
            }

            public TokenBuilder code(String code) {
                this.code = code;
                return this;
            }

            public Token build() {
                return new Token(this.expireIn, this.accessToken, this.refreshToken, this.uid, this.openId, this.accessCode, this.unionId, this.scope, this.tokenType, this.idToken, this.macAlgorithm, this.macKey, this.code);
            }

            public String toString() {
                return "Builder.Token.TokenBuilder(expireIn=" + this.expireIn + ", accessToken=" + this.accessToken + ", refreshToken=" + this.refreshToken + ", uid=" + this.uid + ", openId=" + this.openId + ", accessCode=" + this.accessCode + ", unionId=" + this.unionId + ", scope=" + this.scope + ", tokenType=" + this.tokenType + ", idToken=" + this.idToken + ", macAlgorithm=" + this.macAlgorithm + ", macKey=" + this.macKey + ", code=" + this.code + ")";
            }
        }
    }

    public static enum Type {
        DEFAULT,
        REDIS,
        CUSTOM;


        public String toString() {
            return "Builder.Type." + this.name();
        }
    }

    public static enum Status {
        SUCCESS("2000", "Success"),
        FAILURE("5000", "Failure"),
        NOT_IMPLEMENTED("5001", "Not Implemented"),
        PARAMETER_INCOMPLETE("5002", "Parameter incomplete"),
        UNSUPPORTED("5003", "Unsupported operation"),
        NO_AUTH_SOURCE("5004", "AuthDefaultSource cannot be null"),
        UNIDENTIFIED_PLATFORM("5005", "Unidentified platform"),
        ILLEGAL_REDIRECT_URI("5006", "Illegal redirect uri"),
        ILLEGAL_REQUEST("5007", "Illegal request"),
        ILLEGAL_CODE("5008", "Illegal code");

        private String code;
        private String msg;

        public String getCode() {
            return this.code;
        }

        public String getMsg() {
            return this.msg;
        }

        private Status(String code, String msg) {
            this.code = code;
            this.msg = msg;
        }
    }
}

