/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.io.segment;

import java.nio.ByteBuffer;
import org.aoju.bus.core.io.segment.BufferPage;

public final class VirtualBuffer {
    private final BufferPage bufferPage;
    private ByteBuffer buffer;
    private boolean clean = false;
    private int parentPosition;
    private int parentLimit;

    VirtualBuffer(BufferPage bufferPage, ByteBuffer buffer, int parentPosition, int parentLimit) {
        this.bufferPage = bufferPage;
        this.buffer = buffer;
        this.parentPosition = parentPosition;
        this.parentLimit = parentLimit;
    }

    int getParentPosition() {
        return this.parentPosition;
    }

    void setParentPosition(int parentPosition) {
        this.parentPosition = parentPosition;
    }

    int getParentLimit() {
        return this.parentLimit;
    }

    void setParentLimit(int parentLimit) {
        this.parentLimit = parentLimit;
    }

    public ByteBuffer buffer() {
        return this.buffer;
    }

    void buffer(ByteBuffer buffer) {
        this.buffer = buffer;
        this.clean = false;
    }

    public void clean() {
        if (this.clean) {
            System.err.println("buffer has cleaned");
            throw new RuntimeException();
        }
        this.clean = true;
        if (this.bufferPage != null) {
            this.bufferPage.clean(this);
        }
    }

    public String toString() {
        return "VirtualBuffer{parentPosition=" + this.parentPosition + ", parentLimit=" + this.parentLimit + '}';
    }
}

