/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.swing;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.io.Closeable;
import java.util.LinkedHashSet;
import java.util.Set;
import org.aoju.bus.core.swing.ClipboardListener;
import org.aoju.bus.core.utils.ClipboardUtils;
import org.aoju.bus.core.utils.ObjectUtils;
import org.aoju.bus.core.utils.ThreadUtils;

public enum ClipboardMonitor implements ClipboardOwner,
Runnable,
Closeable
{
    INSTANCE;

    public static final int DEFAULT_TRY_COUNT = 10;
    public static final long DEFAULT_DELAY = 100L;
    private int tryCount;
    private long delay;
    private Clipboard clipboard;
    private Set<ClipboardListener> listenerSet = new LinkedHashSet<ClipboardListener>();
    private boolean isRunning;

    private ClipboardMonitor() {
        this(10, 100L);
    }

    private ClipboardMonitor(int tryCount, long delay) {
        this(tryCount, delay, ClipboardUtils.getClipboard());
    }

    private ClipboardMonitor(int tryCount, long delay, Clipboard clipboard) {
        this.tryCount = tryCount;
        this.delay = delay;
        this.clipboard = clipboard;
    }

    public ClipboardMonitor setTryCount(int tryCount) {
        this.tryCount = tryCount;
        return this;
    }

    public ClipboardMonitor setDelay(long delay) {
        this.delay = delay;
        return this;
    }

    public ClipboardMonitor addListener(ClipboardListener listener) {
        this.listenerSet.add(listener);
        return this;
    }

    public ClipboardMonitor removeListener(ClipboardListener listener) {
        this.listenerSet.remove(listener);
        return this;
    }

    public ClipboardMonitor clearListener() {
        this.listenerSet.clear();
        return this;
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
        Transferable newContents;
        try {
            newContents = this.tryGetContent(clipboard);
        }
        catch (InterruptedException e) {
            return;
        }
        Transferable transferable = null;
        for (ClipboardListener listener : this.listenerSet) {
            try {
                transferable = listener.onChange(clipboard, ObjectUtils.defaultIfNull(transferable, newContents));
            }
            catch (Throwable throwable) {}
        }
        if (this.isRunning) {
            clipboard.setContents(ObjectUtils.defaultIfNull(transferable, ObjectUtils.defaultIfNull(newContents, contents)), this);
        }
    }

    @Override
    public synchronized void run() {
        if (!this.isRunning) {
            Clipboard clipboard = this.clipboard;
            clipboard.setContents(clipboard.getContents(null), this);
            this.isRunning = true;
        }
    }

    public void listen(boolean sync) {
        this.run();
        if (sync) {
            ThreadUtils.sync(this);
        }
    }

    @Override
    public void close() {
        this.isRunning = false;
    }

    private Transferable tryGetContent(Clipboard clipboard) throws InterruptedException {
        Transferable newContents = null;
        for (int i = 0; i < this.tryCount; ++i) {
            if (this.delay > 0L && i > 0) {
                Thread.sleep(this.delay);
            }
            try {
                newContents = clipboard.getContents(null);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            if (null == newContents) continue;
            return newContents;
        }
        return newContents;
    }
}

