/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.storage.provider;

import com.google.common.collect.Maps;
import com.obs.services.ObsClient;
import com.obs.services.model.DownloadFileRequest;
import com.obs.services.model.ListObjectsRequest;
import com.obs.services.model.ObjectListing;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.stream.Collectors;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.storage.Context;
import org.aoju.bus.storage.magic.Attachs;
import org.aoju.bus.storage.magic.Readers;
import org.aoju.bus.storage.provider.AbstractProvider;

public class HuaweiObsProvider
extends AbstractProvider {
    private ObsClient client;

    public HuaweiObsProvider(Context context) {
        this.context = context;
        Assert.notBlank(this.context.getEndpoint(), "[endpoint] not defined", new Object[0]);
        Assert.notBlank(this.context.getBucket(), "[bucket] not defined", new Object[0]);
        Assert.notBlank(this.context.getAccessKey(), "[accessKey] not defined", new Object[0]);
        Assert.notBlank(this.context.getSecretKey(), "[secure] not defined", new Object[0]);
        this.client = new ObsClient(this.context.getAccessKey(), this.context.getSecretKey(), this.context.getEndpoint());
    }

    @Override
    public Readers download(String fileName) {
        return this.download(this.context.getBucket(), fileName);
    }

    @Override
    public Readers download(String bucket, String fileName) {
        return new Readers("-1");
    }

    @Override
    public Readers download(String fileName, File file) {
        return this.download(this.context.getBucket(), fileName, file);
    }

    @Override
    public Readers download(String bucket, String fileName, File file) {
        return new Readers(this.client.downloadFile(new DownloadFileRequest(bucket, this.context.getAccessKey(), fileName)));
    }

    @Override
    public Readers list() {
        ListObjectsRequest request = new ListObjectsRequest(this.context.getBucket());
        ObjectListing objectListing = this.client.listObjects(request);
        return new Readers(objectListing.getObjects().stream().map(item -> {
            Attachs storageItem = new Attachs();
            storageItem.setName(item.getObjectKey());
            storageItem.setOwner(item.getOwner().getId());
            storageItem.setType(item.getMetadata().getContentType());
            storageItem.setSize(StringUtils.toString(item.getMetadata().getContentLength()));
            HashMap extended = Maps.newHashMap();
            extended.put("tag", item.getMetadata().getEtag());
            extended.put("storageClass", item.getMetadata().getObjectStorageClass());
            extended.put("lastModified", item.getMetadata().getLastModified());
            storageItem.setExtended(extended);
            return storageItem;
        }).collect(Collectors.toList()));
    }

    @Override
    public Readers rename(String oldName, String newName) {
        return new Readers("-1");
    }

    @Override
    public Readers rename(String bucket, String oldName, String newName) {
        return new Readers("-1");
    }

    @Override
    public Readers upload(String fileName, byte[] content) {
        return this.upload(this.context.getBucket(), fileName, content);
    }

    @Override
    public Readers upload(String bucket, String fileName, InputStream content) {
        this.client.putObject(bucket, fileName, content);
        return new Readers("0");
    }

    @Override
    public Readers upload(String bucket, String fileName, byte[] content) {
        return new Readers("-1");
    }

    @Override
    public Readers remove(String fileName) {
        return this.remove(this.context.getBucket(), fileName);
    }

    @Override
    public Readers remove(String bucket, String fileName) {
        this.client.deleteObject(bucket, fileName);
        return new Readers("0");
    }

    @Override
    public Readers remove(String bucket, Path path) {
        return this.remove(bucket, path.toString());
    }
}

