/*
 * The MIT License
 *
 * Copyright (c) 2017 aoju.org All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package org.aoju.bus.core.consts;

/**
 * Header 常量
 *
 * @author Kimi Liu
 * @version 5.2.3
 * @since JDK 1.8+
 */
public class Header {

    /**
     * The header Accept
     */
    public static final String ACCEPT = "Accept";
    /**
     * The header Accept-Charset
     */
    public static final String ACCEPT_CHARSET = "Accept-Charset";
    /**
     * The header Accept-Encoding
     */
    public static final String ACCEPT_ENCODING = "Accept-Encoding";
    /**
     * The header Accept-Language
     */
    public static final String ACCEPT_LANGUAGE = "Accept-Language";
    /**
     * The header Accept-Ranges
     */
    public static final String ACCEPT_RANGES = "Accept-Ranges";
    /**
     * The header Age
     */
    public static final String AGE = "Age";
    /**
     * The header Allow
     */
    public static final String ALLOW = "Allow";
    /**
     * The header Cache-Control
     */
    public static final String CACHE_CONTROL = "Cache-Control";
    /**
     * The header Connection
     */
    public static final String CONNECTION = "Connection";
    /**
     * The header Content-Encoding
     */
    public static final String CONTENT_ENCODING = "Content-Encoding";
    /**
     * The header Content-Language
     */
    public static final String CONTENT_LANGUAGE = "Content-Language";
    /**
     * The header Content-Length
     */
    public static final String CONTENT_LENGTH = "Content-Length";
    /**
     * The header Content-Location
     */
    public static final String CONTENT_LOCATION = "Content-Location";
    /**
     * The header Content-MD5
     */
    public static final String CONTENT_MD5 = "Content-MD5";
    /**
     * The header Content-Range
     */
    public static final String CONTENT_RANGE = "Content-Range";
    /**
     * The header Content-Type
     */
    public static final String CONTENT_TYPE = "Content-Type";
    /**
     * The header Content-Disposition
     */
    public static final String CONTENT_DISPOSITION = "Content-Disposition";
    /**
     * The header User-Agent
     */
    public static final String USER_AGENT = "User-Agent";
    /**
     * The header Transfer-Encoding
     */
    public static final String TRANSFER_ENCODING = "Transfer-Encoding";

}
