/*
 * The MIT License
 *
 * Copyright (c) 2017 aoju.org All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package org.aoju.bus.mapper.common.basic.insert;

import org.aoju.bus.mapper.provider.InsertListProvider;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Options;

import java.util.List;

/**
 * 通用Mapper接口,特殊方法,批量插入,支持批量插入的数据库都可以使用,例如mysql,h2等
 *
 * @author Kimi Liu
 * @version 5.2.3
 * @since JDK 1.8+
 */
public interface InsertListMapper<T> {

    /**
     * 批量插入,支持批量插入的数据库可以使用,例如MySQL,H2等
     * <p>
     * 不支持主键策略,插入前需要设置好主键的值
     *
     * @param list 对象列表
     * @return 操作数量
     */
    @InsertProvider(type = InsertListProvider.class, method = "dynamicSQL")
    int insertList(List<T> list);

    /**
     * 批量插入,支持批量插入的数据库可以使用,例如MySQL,H2等,另外该接口限制实体包含`id`属性并且必须为自增列
     *
     * @param list 对象列表
     * @return 操作数量
     */
    @Options(useGeneratedKeys = true, keyProperty = "id")
    @InsertProvider(type = InsertListProvider.class, method = "dynamicSQL")
    int insertListNoId(List<T> list);

    /**
     * 插入数据,限制为实体包含`id`属性并且必须为自增列,实体配置的主键策略无效
     *
     * @param record 对象
     * @return 操作数量
     */
    @Options(useGeneratedKeys = true, keyProperty = "id")
    @InsertProvider(type = InsertListProvider.class, method = "dynamicSQL")
    int insertUseGeneratedKey(T record);
}
