/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.extra;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicInteger;
import org.aoju.bus.core.consts.Charset;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.IoUtils;
import org.aoju.bus.core.utils.NetUtils;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.extra.ssh.ChannelType;
import org.aoju.bus.extra.ssh.Connector;
import org.aoju.bus.extra.ssh.JschSessionPool;
import org.aoju.bus.extra.ssh.Sftp;

public class SSHUtils {
    public static final String SSH_NONE = "none";
    private static final AtomicInteger port = new AtomicInteger(10000);

    public static int generateLocalPort() {
        int validPort = port.get();
        while (!NetUtils.isUsableLocalPort(validPort)) {
            validPort = port.incrementAndGet();
        }
        return validPort;
    }

    public static Session getSession(String sshHost, int sshPort, String sshUser, String sshPass) {
        return JschSessionPool.INSTANCE.getSession(sshHost, sshPort, sshUser, sshPass);
    }

    public static Session openSession(String sshHost, int sshPort, String sshUser, String sshPass) {
        Session session = SSHUtils.createSession(sshHost, sshPort, sshUser, sshPass);
        try {
            session.connect();
        }
        catch (JSchException e) {
            throw new InstrumentException(e);
        }
        return session;
    }

    public static Session openSession(String sshHost, int sshPort, String sshUser, String privateKeyPath, byte[] passphrase) {
        Session session = SSHUtils.createSession(sshHost, sshPort, sshUser, privateKeyPath, passphrase);
        try {
            session.connect();
        }
        catch (JSchException e) {
            throw new InstrumentException(e);
        }
        return session;
    }

    public static Session createSession(String sshHost, int sshPort, String sshUser, String sshPass) {
        JSch jsch = new JSch();
        Session session = SSHUtils.createSession(jsch, sshHost, sshPort, sshUser);
        if (StringUtils.isNotEmpty(sshPass)) {
            session.setPassword(sshPass);
        }
        return session;
    }

    public static Session createSession(String sshHost, int sshPort, String sshUser, String privateKeyPath, byte[] passphrase) {
        Assert.notEmpty(privateKeyPath, "PrivateKey Path must be not empty!", new Object[0]);
        JSch jsch = new JSch();
        try {
            jsch.addIdentity(privateKeyPath, passphrase);
        }
        catch (JSchException e) {
            throw new InstrumentException(e);
        }
        return SSHUtils.createSession(jsch, sshHost, sshPort, sshUser);
    }

    public static Session createSession(JSch jsch, String sshHost, int sshPort, String sshUser) {
        Session session;
        Assert.notEmpty(sshHost, "SSH Host must be not empty!", new Object[0]);
        Assert.isTrue(sshPort > 0, "SSH port must be > 0", new Object[0]);
        if (StringUtils.isEmpty(sshUser)) {
            sshUser = "root";
        }
        if (null == jsch) {
            jsch = new JSch();
        }
        try {
            session = jsch.getSession(sshUser, sshHost, sshPort);
        }
        catch (JSchException e) {
            throw new InstrumentException(e);
        }
        session.setConfig("StrictHostKeyChecking", "no");
        return session;
    }

    public static boolean bindPort(Session session, String remoteHost, int remotePort, int localPort) throws InstrumentException {
        if (session != null && session.isConnected()) {
            try {
                session.setPortForwardingL(localPort, remoteHost, remotePort);
            }
            catch (JSchException e) {
                throw new InstrumentException("From [{" + remoteHost + "}] mapping to [{" + localPort + "}] error\uff01");
            }
            return true;
        }
        return false;
    }

    public static boolean unBindPort(Session session, int localPort) {
        try {
            session.delPortForwardingL(localPort);
            return true;
        }
        catch (JSchException e) {
            throw new InstrumentException(e);
        }
    }

    public static int openAndBindPortToLocal(Connector sshConn, String remoteHost, int remotePort) throws InstrumentException {
        Session session = SSHUtils.openSession(sshConn.getHost(), sshConn.getPort(), sshConn.getUser(), sshConn.getPassword());
        if (session == null) {
            throw new InstrumentException("Error to create SSH Session\uff01");
        }
        int localPort = SSHUtils.generateLocalPort();
        SSHUtils.bindPort(session, remoteHost, remotePort, localPort);
        return localPort;
    }

    public static ChannelSftp openSftp(Session session) {
        return (ChannelSftp)SSHUtils.openChannel(session, ChannelType.SFTP);
    }

    public static Sftp createSftp(String sshHost, int sshPort, String sshUser, String sshPass) {
        return new Sftp(sshHost, sshPort, sshUser, sshPass);
    }

    public static Sftp createSftp(Session session) {
        return new Sftp(session);
    }

    public static ChannelShell openShell(Session session) {
        return (ChannelShell)SSHUtils.openChannel(session, ChannelType.SHELL);
    }

    public static Channel openChannel(Session session, ChannelType channelType) {
        Channel channel = SSHUtils.createChannel(session, channelType);
        try {
            channel.connect();
        }
        catch (JSchException e) {
            throw new InstrumentException(e);
        }
        return channel;
    }

    public static Channel createChannel(Session session, ChannelType channelType) {
        Channel channel;
        try {
            if (!session.isConnected()) {
                session.connect();
            }
            channel = session.openChannel(channelType.getValue());
        }
        catch (JSchException e) {
            throw new InstrumentException(e);
        }
        return channel;
    }

    public static String exec(Session session, String cmd, java.nio.charset.Charset charset) {
        return SSHUtils.exec(session, cmd, charset, System.err);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String exec(Session session, String cmd, java.nio.charset.Charset charset, OutputStream errStream) {
        String string;
        if (null == charset) {
            charset = Charset.UTF_8;
        }
        ChannelExec channel = (ChannelExec)SSHUtils.openChannel(session, ChannelType.EXEC);
        channel.setCommand(StringUtils.bytes((CharSequence)cmd, charset));
        channel.setInputStream(null);
        channel.setErrStream(errStream);
        InputStream in = null;
        try {
            channel.start();
            in = channel.getInputStream();
            string = IoUtils.read(in, Charset.UTF_8);
        }
        catch (IOException e) {
            try {
                throw new InstrumentException(e);
                catch (JSchException e2) {
                    throw new InstrumentException(e2);
                }
            }
            catch (Throwable throwable) {
                IoUtils.close(in);
                SSHUtils.close((Channel)channel);
                throw throwable;
            }
        }
        IoUtils.close(in);
        SSHUtils.close((Channel)channel);
        return string;
    }

    public static void close(Session session) {
        if (session != null && session.isConnected()) {
            session.disconnect();
        }
        JschSessionPool.INSTANCE.remove(session);
    }

    public static void close(Channel channel) {
        if (channel != null && channel.isConnected()) {
            channel.disconnect();
        }
    }

    public static void close(String key) {
        JschSessionPool.INSTANCE.close(key);
    }

    public static void closeAll() {
        JschSessionPool.INSTANCE.closeAll();
    }
}

