/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.setting;

import java.io.Serializable;
import java.lang.reflect.Type;
import org.aoju.bus.core.beans.copier.CopyOptions;
import org.aoju.bus.core.beans.copier.ValueProvider;
import org.aoju.bus.core.convert.Convert;
import org.aoju.bus.core.getter.OptNullString;
import org.aoju.bus.core.utils.BeanUtils;
import org.aoju.bus.core.utils.StringUtils;

public abstract class AbsSetting
extends OptNullString<String>
implements Serializable {
    @Override
    public String getStr(String key, String defaultValue) {
        return this.getStr(key, "", defaultValue);
    }

    public String getStr(String key, String group, String defaultValue) {
        String value = this.getByGroup(key, group);
        if (StringUtils.isBlank(value)) {
            return defaultValue;
        }
        return value;
    }

    public abstract String getByGroup(String var1, String var2);

    public String getWithLog(String key) {
        return this.getStr(key);
    }

    public String getByGroupWithLog(String key, String group) {
        return this.getByGroup(key, group);
    }

    public String[] getStrings(String key) {
        return this.getStrings(key, null);
    }

    public String[] getStringsWithDefault(String key, String[] defaultValue) {
        String[] value = this.getStrings(key, null);
        if (null == value) {
            value = defaultValue;
        }
        return value;
    }

    public String[] getStrings(String key, String group) {
        return this.getStrings(key, group, ",");
    }

    public String[] getStrings(String key, String group, String delimiter) {
        String value = this.getByGroup(key, group);
        if (StringUtils.isBlank(value)) {
            return null;
        }
        return StringUtils.split((CharSequence)value, delimiter);
    }

    public Integer getInt(String key, String group) {
        return this.getInt(key, group, null);
    }

    public Integer getInt(String key, String group, Integer defaultValue) {
        return Convert.toInt(this.getByGroup(key, group), defaultValue);
    }

    public Boolean getBool(String key, String group) {
        return this.getBool(key, group, null);
    }

    public Boolean getBool(String key, String group, Boolean defaultValue) {
        return Convert.toBool(this.getByGroup(key, group), defaultValue);
    }

    public Long getLong(String key, String group) {
        return this.getLong(key, group, null);
    }

    public Long getLong(String key, String group, Long defaultValue) {
        return Convert.toLong(this.getByGroup(key, group), defaultValue);
    }

    public Character getChar(String key, String group) {
        String value = this.getByGroup(key, group);
        if (StringUtils.isBlank(value)) {
            return null;
        }
        return Character.valueOf(value.charAt(0));
    }

    public Double getDouble(String key, String group) {
        return this.getDouble(key, group, null);
    }

    public Double getDouble(String key, String group, Double defaultValue) {
        return Convert.toDouble(this.getByGroup(key, group), defaultValue);
    }

    public <T> T toBean(final String group, T bean) {
        return BeanUtils.fillBean(bean, new ValueProvider<String>(){

            @Override
            public Object value(String key, Type valueType) {
                return AbsSetting.this.getByGroup(key, group);
            }

            @Override
            public boolean containsKey(String key) {
                return null != AbsSetting.this.getByGroup(key, group);
            }
        }, CopyOptions.create());
    }

    public <T> T toBean(T bean) {
        return this.toBean(null, bean);
    }
}

