/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.utils;

import java.awt.AWTException;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.ClipboardUtils;
import org.aoju.bus.core.utils.ImageUtils;
import org.aoju.bus.core.utils.UriUtils;

public class DesktopUtils {
    private static final Robot robot;
    public static Dimension dimension;
    private static int delay;

    public static int getWidth() {
        return (int)dimension.getWidth();
    }

    public static int getHeight() {
        return (int)dimension.getHeight();
    }

    public static Rectangle getRectangle() {
        return new Rectangle(DesktopUtils.getWidth(), DesktopUtils.getHeight());
    }

    public static void setDelay(int delayMillis) {
        delay = delayMillis;
    }

    public static void mouseMove(int x, int y) {
        robot.mouseMove(x, y);
    }

    public static void click() {
        robot.mousePress(16);
        robot.mouseRelease(16);
        DesktopUtils.delay();
    }

    public static void rightClick() {
        robot.mousePress(16);
        robot.mouseRelease(16);
        DesktopUtils.delay();
    }

    public static void mouseWheel(int wheelAmt) {
        robot.mouseWheel(wheelAmt);
        DesktopUtils.delay();
    }

    public static void keyClick(int ... keyCodes) {
        for (int keyCode : keyCodes) {
            robot.keyPress(keyCode);
            robot.keyRelease(keyCode);
        }
        DesktopUtils.delay();
    }

    public static void keyPressString(String str) {
        ClipboardUtils.setStr(str);
        DesktopUtils.keyPressWithCtrl(86);
        DesktopUtils.delay();
    }

    public static void keyPressWithShift(int key) {
        robot.keyPress(16);
        robot.keyPress(key);
        robot.keyRelease(key);
        robot.keyRelease(16);
        DesktopUtils.delay();
    }

    public static void keyPressWithCtrl(int key) {
        robot.keyPress(17);
        robot.keyPress(key);
        robot.keyRelease(key);
        robot.keyRelease(17);
        DesktopUtils.delay();
    }

    public static void keyPressWithAlt(int key) {
        robot.keyPress(18);
        robot.keyPress(key);
        robot.keyRelease(key);
        robot.keyRelease(18);
        DesktopUtils.delay();
    }

    public static BufferedImage captureScreen() {
        return DesktopUtils.captureScreen(DesktopUtils.getRectangle());
    }

    public static File captureScreen(File outFile) {
        ImageUtils.write(DesktopUtils.captureScreen(), outFile);
        return outFile;
    }

    public static BufferedImage captureScreen(Rectangle screenRect) {
        return robot.createScreenCapture(screenRect);
    }

    public static File captureScreen(Rectangle screenRect, File outFile) {
        ImageUtils.write(DesktopUtils.captureScreen(screenRect), outFile);
        return outFile;
    }

    private static void delay() {
        if (delay > 0) {
            robot.delay(delay);
        }
    }

    public static Desktop getDsktop() {
        return Desktop.getDesktop();
    }

    public static void browse(String url) {
        DesktopUtils.browse(UriUtils.toURI(url));
    }

    public static void browse(URI uri) {
        Desktop dsktop = DesktopUtils.getDsktop();
        try {
            dsktop.browse(uri);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static void open(File file) {
        Desktop dsktop = DesktopUtils.getDsktop();
        try {
            dsktop.open(file);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static void edit(File file) {
        Desktop dsktop = DesktopUtils.getDsktop();
        try {
            dsktop.edit(file);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static void print(File file) {
        Desktop dsktop = DesktopUtils.getDsktop();
        try {
            dsktop.print(file);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static void mail(String mailAddress) {
        Desktop dsktop = DesktopUtils.getDsktop();
        try {
            dsktop.mail(UriUtils.toURI(mailAddress));
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    static {
        dimension = Toolkit.getDefaultToolkit().getScreenSize();
        try {
            robot = new Robot();
        }
        catch (AWTException e) {
            throw new InstrumentException(e);
        }
    }
}

