/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;
import org.aoju.bus.health.HealthUtils;

public class HostInfo {
    private final String HOST_NAME;
    private final String HOST_ADDRESS;

    public HostInfo() {
        String hostAddress;
        String hostName;
        try {
            InetAddress localhost = HostInfo.getLocalAddress();
            hostName = localhost.getHostName();
            hostAddress = localhost.getHostAddress();
        }
        catch (UnknownHostException e) {
            hostName = "localhost";
            hostAddress = "127.0.0.1";
        }
        this.HOST_NAME = hostName;
        this.HOST_ADDRESS = hostAddress;
    }

    public static InetAddress getLocalAddress() throws UnknownHostException {
        try {
            InetAddress inetAddress = null;
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                Enumeration<InetAddress> inetAddrs = iface.getInetAddresses();
                while (inetAddrs.hasMoreElements()) {
                    InetAddress inetAddr = inetAddrs.nextElement();
                    if (inetAddr.isLoopbackAddress()) continue;
                    if (inetAddr.isSiteLocalAddress()) {
                        return inetAddr;
                    }
                    if (inetAddress != null) continue;
                    inetAddress = inetAddr;
                }
            }
            if (inetAddress != null) {
                return inetAddress;
            }
            inetAddress = InetAddress.getLocalHost();
            if (inetAddress == null) {
                throw new UnknownHostException("The JDK InetAddress.getLocalHost() method unexpectedly returned null.");
            }
            return inetAddress;
        }
        catch (Exception e) {
            UnknownHostException unknownHostException = new UnknownHostException("Failed to determine LAN address: " + e);
            unknownHostException.initCause(e);
            throw unknownHostException;
        }
    }

    public final String getName() {
        return this.HOST_NAME;
    }

    public final String getAddress() {
        return this.HOST_ADDRESS;
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        HealthUtils.append(builder, "Host Name:    ", this.getName());
        HealthUtils.append(builder, "Host Address: ", this.getAddress());
        return builder.toString();
    }
}

