/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter.cache;

import org.aoju.bus.cache.Aspectj;
import org.aoju.bus.cache.Context;
import org.aoju.bus.cache.provider.H2Provider;
import org.aoju.bus.cache.provider.MemoryProvider;
import org.aoju.bus.cache.provider.MySQLProvider;
import org.aoju.bus.cache.provider.SqliteProvider;
import org.aoju.bus.cache.provider.ZKProvider;
import org.aoju.bus.core.utils.ClassUtils;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.starter.cache.CacheProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@EnableConfigurationProperties(value={CacheProperties.class})
public class CacheConfiguration {
    @Autowired
    CacheProperties properties;
    @Autowired
    Aspectj cacheAspect = this.cacheConfigurer();

    @Bean
    public Aspectj cacheConfigurer() {
        String type = StringUtils.toString(this.properties.getType());
        try {
            if (!StringUtils.isEmpty(type)) {
                Class provider = ClassUtils.loadClass(type);
                Context config = Context.newConfig(this.properties.getMap());
                if (provider instanceof H2Provider || provider instanceof MySQLProvider || provider instanceof SqliteProvider || provider instanceof ZKProvider || provider instanceof MemoryProvider) {
                    // empty if block
                }
                this.cacheAspect = new Aspectj(config);
                return this.cacheAspect;
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("can not resolve class with type: " + type);
        }
        return null;
    }
}

