/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.tracer;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.WeakHashMap;
import org.aoju.bus.tracer.Provider;
import org.aoju.bus.tracer.backend.TraceBackendProvider;

public class Resolver {
    private static volatile Map<ClassLoader, Set<TraceBackendProvider>> providersPerClassloader = new WeakHashMap<ClassLoader, Set<TraceBackendProvider>>();

    public Set<TraceBackendProvider> getBackendProviders() {
        Map<ClassLoader, Set<TraceBackendProvider>> cacheCopy = providersPerClassloader;
        Set<TraceBackendProvider> providerFromContextClassLoader = this.getTraceProviderFromClassloader(cacheCopy, GetClassLoader.fromContext());
        if (!providerFromContextClassLoader.isEmpty()) {
            return providerFromContextClassLoader;
        }
        return this.getTraceProviderFromClassloader(cacheCopy, GetClassLoader.fromClass(Resolver.class));
    }

    Set<TraceBackendProvider> getDefaultTraceBackendProvider() {
        try {
            ClassLoader classLoader = GetClassLoader.fromContext();
            Class<?> slf4jTraceBackendProviderClass = Class.forName("org.aoju.bus.tracer.backend.Slf4jTraceBackendProvider", true, classLoader);
            TraceBackendProvider instance = (TraceBackendProvider)slf4jTraceBackendProviderClass.newInstance();
            this.updatedCache(classLoader, Collections.singleton(instance));
            return Collections.singleton(instance);
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            return Collections.emptySet();
        }
    }

    private Set<TraceBackendProvider> getTraceProviderFromClassloader(Map<ClassLoader, Set<TraceBackendProvider>> cacheCopy, ClassLoader classLoader) {
        Set<TraceBackendProvider> classLoaderProviders = cacheCopy.get(classLoader);
        if (this.isLookupNeeded(classLoaderProviders)) {
            classLoaderProviders = this.loadProviders(classLoader);
            this.updatedCache(classLoader, classLoaderProviders);
        }
        return classLoaderProviders;
    }

    boolean isLookupNeeded(Set<TraceBackendProvider> classLoaderProviders) {
        return classLoaderProviders == null || !(classLoaderProviders instanceof EmptyBackendProviderSet) && classLoaderProviders.isEmpty();
    }

    private void updatedCache(ClassLoader classLoader, Set<TraceBackendProvider> provider) {
        WeakHashMap<ClassLoader, Set<TraceBackendProvider>> copyOnWriteMap = new WeakHashMap<ClassLoader, Set<TraceBackendProvider>>(providersPerClassloader);
        if (!provider.isEmpty()) {
            copyOnWriteMap.put(classLoader, new Provider(provider));
        } else {
            copyOnWriteMap.put(classLoader, new EmptyBackendProviderSet());
        }
        providersPerClassloader = copyOnWriteMap;
    }

    private Set<TraceBackendProvider> loadProviders(ClassLoader classloader) {
        ServiceLoader<TraceBackendProvider> loader = ServiceLoader.load(TraceBackendProvider.class, classloader);
        Iterator<TraceBackendProvider> providerIterator = loader.iterator();
        HashSet<TraceBackendProvider> TraceProvider = new HashSet<TraceBackendProvider>();
        while (providerIterator.hasNext()) {
            try {
                TraceProvider.add(providerIterator.next());
            }
            catch (ServiceConfigurationError serviceConfigurationError) {}
        }
        return TraceProvider;
    }

    static final class EmptyBackendProviderSet
    extends AbstractSet<TraceBackendProvider> {
        EmptyBackendProviderSet() {
        }

        @Override
        public Iterator<TraceBackendProvider> iterator() {
            return Collections.emptyList().iterator();
        }

        @Override
        public int size() {
            return 0;
        }
    }

    static final class GetClassLoader
    implements PrivilegedAction<ClassLoader> {
        private final Class<?> clazz;

        private GetClassLoader(Class<?> clazz) {
            this.clazz = clazz;
        }

        public static ClassLoader fromContext() {
            return GetClassLoader.doPrivileged(new GetClassLoader(null));
        }

        public static ClassLoader fromClass(Class<?> clazz) {
            if (clazz == null) {
                throw new IllegalArgumentException("Class is null");
            }
            return GetClassLoader.doPrivileged(new GetClassLoader(clazz));
        }

        private static ClassLoader doPrivileged(GetClassLoader action) {
            if (System.getSecurityManager() != null) {
                return AccessController.doPrivileged(action);
            }
            return action.run();
        }

        @Override
        public ClassLoader run() {
            if (this.clazz != null) {
                return this.clazz.getClassLoader();
            }
            return Thread.currentThread().getContextClassLoader();
        }
    }
}

