/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.cache;

import java.util.Map;

public interface Provider {
    public void reqIncr(String var1, int var2);

    public void hitIncr(String var1, int var2);

    public Map<String, ShootingDO> getShooting();

    public void reset(String var1);

    public void resetAll();

    default public String summaryName() {
        return "zh".equalsIgnoreCase(System.getProperty("user.language")) ? "\u5168\u5c40" : "summary";
    }

    public static class ShootingDO {
        private long hit;
        private long required;
        private String rate;

        private ShootingDO(long hit, long required, String rate) {
            this.hit = hit;
            this.required = required;
            this.rate = rate;
        }

        public static ShootingDO newInstance(long hit, long required) {
            double rate = required == 0L ? 0.0 : (double)hit * 100.0 / (double)required;
            String rateStr = String.format("%.1f%s", rate, "%");
            return new ShootingDO(hit, required, rateStr);
        }

        public static ShootingDO mergeShootingDO(ShootingDO do1, ShootingDO do2) {
            long hit = do1.getHit() + do2.getHit();
            long required = do1.getRequired() + do2.getRequired();
            return ShootingDO.newInstance(hit, required);
        }

        public long getHit() {
            return this.hit;
        }

        public long getRequired() {
            return this.required;
        }

        public String getRate() {
            return this.rate;
        }
    }
}

