/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.utils;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.aoju.bus.core.beans.BeanDesc;
import org.aoju.bus.core.beans.copier.BeanCopier;
import org.aoju.bus.core.beans.copier.CopyOptions;
import org.aoju.bus.core.beans.copier.ValueProvider;
import org.aoju.bus.core.convert.BasicType;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.Editor;
import org.aoju.bus.core.lang.Filter;
import org.aoju.bus.core.lang.SimpleCache;
import org.aoju.bus.core.lang.Singleton;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.lang.mutable.MutableObject;
import org.aoju.bus.core.loader.JarLoaders;
import org.aoju.bus.core.utils.ArrayUtils;
import org.aoju.bus.core.utils.CollUtils;
import org.aoju.bus.core.utils.FileUtils;
import org.aoju.bus.core.utils.ReflectUtils;
import org.aoju.bus.core.utils.ResourceUtils;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.core.utils.TypeUtils;
import org.aoju.bus.core.utils.UriUtils;

public class ClassUtils {
    private static final Map<String, Class<?>> primitiveWrapperMap = new HashMap();
    private static final Map<Class<?>, Class<?>> wrapperPrimitiveMap = new HashMap();
    private static SimpleCache<String, Class<?>> classCache = new SimpleCache();

    public static <T> Class<T> getClass(T obj) {
        return null == obj ? null : obj.getClass();
    }

    public static String getClassName(Object obj, boolean isSimple) {
        if (null == obj) {
            return null;
        }
        Class<?> clazz = obj.getClass();
        return ClassUtils.getClassName(clazz, isSimple);
    }

    public static String getClassName(Class<?> clazz, boolean isSimple) {
        if (null == clazz) {
            return null;
        }
        return isSimple ? clazz.getSimpleName() : clazz.getName();
    }

    public static Class<?>[] getClasses(Object ... objects) {
        Class[] classes = new Class[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            Object obj = objects[i];
            classes[i] = null == obj ? Object.class : obj.getClass();
        }
        return classes;
    }

    public static boolean equals(Class<?> clazz, String className, boolean ignoreCase) {
        if (null == clazz || StringUtils.isBlank(className)) {
            return false;
        }
        if (ignoreCase) {
            return className.equalsIgnoreCase(clazz.getName()) || className.equalsIgnoreCase(clazz.getSimpleName());
        }
        return className.equals(clazz.getName()) || className.equals(clazz.getSimpleName());
    }

    public static Set<String> getPublicMethodNames(Class<?> clazz) {
        Method[] methodArray;
        HashSet<String> methodSet = new HashSet<String>();
        for (Method method : methodArray = ClassUtils.getPublicMethods(clazz)) {
            String methodName = method.getName();
            methodSet.add(methodName);
        }
        return methodSet;
    }

    public static Method[] getPublicMethods(Class<?> clazz) {
        return clazz.getMethods();
    }

    public static List<Method> getPublicMethods(Class<?> clazz, Filter<Method> filter) {
        ArrayList<Method> methodList;
        if (null == clazz) {
            return null;
        }
        Method[] methods = ClassUtils.getPublicMethods(clazz);
        if (null != filter) {
            methodList = new ArrayList();
            for (Method method : methods) {
                if (!filter.accept(method)) continue;
                methodList.add(method);
            }
        } else {
            methodList = CollUtils.newArrayList(methods);
        }
        return methodList;
    }

    public static List<Method> getPublicMethods(Class<?> clazz, Method ... excludeMethods) {
        final HashSet<Method> excludeMethodSet = CollUtils.newHashSet(excludeMethods);
        return ClassUtils.getPublicMethods(clazz, new Filter<Method>(){

            @Override
            public boolean accept(Method method) {
                return false == excludeMethodSet.contains(method);
            }
        });
    }

    public static List<Method> getPublicMethods(Class<?> clazz, String ... excludeMethodNames) {
        final HashSet<String> excludeMethodNameSet = CollUtils.newHashSet(excludeMethodNames);
        return ClassUtils.getPublicMethods(clazz, new Filter<Method>(){

            @Override
            public boolean accept(Method method) {
                return false == excludeMethodNameSet.contains(method.getName());
            }
        });
    }

    public static Method getPublicMethod(Class<?> clazz, String methodName, Class<?> ... paramTypes) throws SecurityException {
        try {
            return clazz.getMethod(methodName, paramTypes);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    public static Set<String> getDeclaredMethodNames(Class<?> clazz) {
        return ReflectUtils.getMethodNames(clazz);
    }

    public static Method[] getDeclaredMethods(Class<?> clazz) {
        return ReflectUtils.getMethods(clazz);
    }

    public static Method getDeclaredMethodOfObj(Object obj, String methodName, Object ... args) throws SecurityException {
        return ClassUtils.getDeclaredMethod(obj.getClass(), methodName, ClassUtils.getClasses(args));
    }

    public static Method getDeclaredMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) throws SecurityException {
        return ReflectUtils.getMethod(clazz, methodName, parameterTypes);
    }

    public static Field getDeclaredField(Class<?> clazz, String fieldName) throws SecurityException {
        if (null == clazz || StringUtils.isBlank(fieldName)) {
            return null;
        }
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            throw new InstrumentException(e);
        }
    }

    public static Field[] getDeclaredFields(Class<?> clazz) throws SecurityException {
        if (null == clazz) {
            return null;
        }
        return clazz.getDeclaredFields();
    }

    public static String[] getJavaClassPaths() {
        String[] classPaths = System.getProperty("java.class.path").split(System.getProperty("path.separator"));
        return classPaths;
    }

    public static boolean isAllAssignableFrom(Class<?>[] types1, Class<?>[] types2) {
        if (ArrayUtils.isEmpty(types1) && ArrayUtils.isEmpty(types2)) {
            return true;
        }
        if (types1.length != types2.length) {
            return false;
        }
        for (int i = 0; i < types1.length; ++i) {
            Class<?> type1 = types1[i];
            Class<?> type2 = types2[i];
            if (!(ClassUtils.isBasicType(type1) && ClassUtils.isBasicType(type2) ? BasicType.unWrap(type1) != BasicType.unWrap(type2) : false == type1.isAssignableFrom(type2))) continue;
            return false;
        }
        return true;
    }

    public static <T> T invoke(String classNameWithMethodName, Object[] args) {
        return ClassUtils.invoke(classNameWithMethodName, false, args);
    }

    public static <T> T invoke(String classNameWithMethodName, boolean isSingleton, Object ... args) {
        if (StringUtils.isBlank(classNameWithMethodName)) {
            throw new InstrumentException("Blank classNameDotMethodName!");
        }
        int splitIndex = classNameWithMethodName.lastIndexOf(35);
        if (splitIndex <= 0) {
            splitIndex = classNameWithMethodName.lastIndexOf(46);
        }
        if (splitIndex <= 0) {
            throw new InstrumentException("Invalid classNameWithMethodName [{}]!", classNameWithMethodName);
        }
        String className = classNameWithMethodName.substring(0, splitIndex);
        String methodName = classNameWithMethodName.substring(splitIndex + 1);
        return ClassUtils.invoke(className, methodName, isSingleton, args);
    }

    public static <T> T invoke(String className, String methodName, Object[] args) {
        return ClassUtils.invoke(className, methodName, false, args);
    }

    public static <T> T invoke(String className, String methodName, boolean isSingleton, Object ... args) {
        Class<T> clazz = ClassUtils.loadClass(className);
        try {
            Method method = ClassUtils.getDeclaredMethod(clazz, methodName, ClassUtils.getClasses(args));
            if (null == method) {
                throw new NoSuchMethodException(StringUtils.format("No such method: [{}]", methodName));
            }
            if (ClassUtils.isStatic(method)) {
                return ReflectUtils.invoke(null, method, args);
            }
            return ReflectUtils.invoke(isSingleton ? Singleton.get(clazz, new Object[0]) : clazz.newInstance(), method, args);
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }

    public static boolean isPrimitiveWrapper(Class<?> clazz) {
        if (null == clazz) {
            return false;
        }
        return BasicType.wrapperPrimitiveMap.containsKey(clazz);
    }

    public static boolean isBasicType(Class<?> clazz) {
        if (null == clazz) {
            return false;
        }
        return clazz.isPrimitive() || ClassUtils.isPrimitiveWrapper(clazz);
    }

    public static boolean isSimpleTypeOrArray(Class<?> clazz) {
        if (null == clazz) {
            return false;
        }
        return ClassUtils.isSimpleValueType(clazz) || clazz.isArray() && ClassUtils.isSimpleValueType(clazz.getComponentType());
    }

    public static boolean isSimpleValueType(Class<?> clazz) {
        return ClassUtils.isBasicType(clazz) || clazz.isEnum() || CharSequence.class.isAssignableFrom(clazz) || Number.class.isAssignableFrom(clazz) || Date.class.isAssignableFrom(clazz) || clazz.equals(URI.class) || clazz.equals(URL.class) || clazz.equals(Locale.class) || clazz.equals(Class.class);
    }

    public static boolean isAssignable(Class<?>[] classArray, Class<?> ... toClassArray) {
        return ClassUtils.isAssignable(classArray, toClassArray, true);
    }

    public static boolean isAssignable(Class<?> classArray, Class<?> toClassArray) {
        return ClassUtils.isAssignable(classArray, toClassArray, true);
    }

    public static boolean isAssignable(Class<?>[] classArray, Class<?>[] toClassArray, boolean autoboxing) {
        if (!ArrayUtils.isSameLength(classArray, toClassArray)) {
            return false;
        }
        if (classArray == null) {
            classArray = ArrayUtils.EMPTY_CLASS_ARRAY;
        }
        if (toClassArray == null) {
            toClassArray = ArrayUtils.EMPTY_CLASS_ARRAY;
        }
        for (int i = 0; i < classArray.length; ++i) {
            if (ClassUtils.isAssignable(classArray[i], toClassArray[i], autoboxing)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAssignable(Class<?> cls, Class<?> toClass, boolean autoboxing) {
        if (toClass == null) {
            return false;
        }
        if (cls == null) {
            return !toClass.isPrimitive();
        }
        if (autoboxing) {
            if (cls.isPrimitive() && !toClass.isPrimitive() && (cls = ClassUtils.primitiveToWrapper(cls)) == null) {
                return false;
            }
            if (toClass.isPrimitive() && !cls.isPrimitive() && (cls = ClassUtils.wrapperToPrimitive(cls)) == null) {
                return false;
            }
        }
        if (cls.equals(toClass)) {
            return true;
        }
        if (cls.isPrimitive()) {
            if (!toClass.isPrimitive()) {
                return false;
            }
            if (Integer.TYPE.equals(cls)) {
                return Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Long.TYPE.equals(cls)) {
                return Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Boolean.TYPE.equals(cls)) {
                return false;
            }
            if (Double.TYPE.equals(cls)) {
                return false;
            }
            if (Float.TYPE.equals(cls)) {
                return Double.TYPE.equals(toClass);
            }
            if (Character.TYPE.equals(cls)) {
                return Integer.TYPE.equals(toClass) || Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Short.TYPE.equals(cls)) {
                return Integer.TYPE.equals(toClass) || Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Byte.TYPE.equals(cls)) {
                return Short.TYPE.equals(toClass) || Integer.TYPE.equals(toClass) || Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            return false;
        }
        return toClass.isAssignableFrom(cls);
    }

    public static boolean isPublic(Class<?> clazz) {
        if (null == clazz) {
            throw new NullPointerException("Class to provided is null.");
        }
        return Modifier.isPublic(clazz.getModifiers());
    }

    public static boolean isPublic(Method method) {
        if (null == method) {
            throw new NullPointerException("Method to provided is null.");
        }
        return ClassUtils.isPublic(method.getDeclaringClass());
    }

    public static boolean isNotPublic(Class<?> clazz) {
        return false == ClassUtils.isPublic(clazz);
    }

    public static boolean isNotPublic(Method method) {
        return false == ClassUtils.isPublic(method);
    }

    public static boolean isStatic(Method method) {
        return Modifier.isStatic(method.getModifiers());
    }

    public static Method setAccessible(Method method) {
        if (null != method && !method.isAccessible()) {
            method.setAccessible(true);
        }
        return method;
    }

    public static boolean isAbstract(Class<?> clazz) {
        return Modifier.isAbstract(clazz.getModifiers());
    }

    public static boolean isNormalClass(Class<?> clazz) {
        return null != clazz && false == clazz.isInterface() && false == ClassUtils.isAbstract(clazz) && false == clazz.isEnum() && false == clazz.isArray() && false == clazz.isAnnotation() && false == clazz.isSynthetic() && false == clazz.isPrimitive();
    }

    public static boolean isEnum(Class<?> clazz) {
        return null != clazz && clazz.isEnum();
    }

    public static Class<?> getTypeArgument(Class<?> clazz) {
        return ClassUtils.getTypeArgument(clazz, 0);
    }

    public static Class<?> getTypeArgument(Class<?> clazz, int index) {
        Type argumentType = TypeUtils.getTypeArgument(clazz, index);
        if (null != argumentType && argumentType instanceof Class) {
            return (Class)argumentType;
        }
        return null;
    }

    public static String getPackage(Class<?> clazz) {
        if (clazz == null) {
            return "";
        }
        String className = clazz.getName();
        int packageEndIndex = className.lastIndexOf(".");
        if (packageEndIndex == -1) {
            return "";
        }
        return className.substring(0, packageEndIndex);
    }

    public static String getPackagePath(Class<?> clazz) {
        return ClassUtils.getPackage(clazz).replace('.', '/');
    }

    public static Object getDefaultValue(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            if (Long.TYPE == clazz) {
                return 0L;
            }
            if (Integer.TYPE == clazz) {
                return 0;
            }
            if (Short.TYPE == clazz) {
                return (short)0;
            }
            if (Character.TYPE == clazz) {
                return Character.valueOf('\u0000');
            }
            if (Byte.TYPE == clazz) {
                return (byte)0;
            }
            if (Double.TYPE == clazz) {
                return 0.0;
            }
            if (Float.TYPE == clazz) {
                return Float.valueOf(0.0f);
            }
            if (Boolean.TYPE == clazz) {
                return false;
            }
        }
        return null;
    }

    public static Object[] getDefaultValues(Class<?> ... classes) {
        Object[] values = new Object[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            values[i] = ClassUtils.getDefaultValue(classes[i]);
        }
        return values;
    }

    public static boolean isBean(Class<?> clazz) {
        if (ClassUtils.isNormalClass(clazz)) {
            Method[] methods;
            for (Method method : methods = clazz.getMethods()) {
                if (method.getParameterTypes().length != 1 || !method.getName().startsWith("set")) continue;
                return true;
            }
        }
        return false;
    }

    public static Map<String, Object> beanToMap(Object bean) {
        return ClassUtils.beanToMap(bean, false, false);
    }

    public static Map<String, Object> beanToMap(Object bean, boolean isToUnderlineCase, boolean ignoreNullValue) {
        return ClassUtils.beanToMap(bean, new HashMap<String, Object>(), isToUnderlineCase, ignoreNullValue);
    }

    public static Map<String, Object> beanToMap(Object bean, Map<String, Object> targetMap, final boolean isToUnderlineCase, boolean ignoreNullValue) {
        if (bean == null) {
            return null;
        }
        return ClassUtils.beanToMap(bean, targetMap, ignoreNullValue, new Editor<String>(){

            @Override
            public String edit(String key) {
                return isToUnderlineCase ? StringUtils.toUnderlineCase(key) : key;
            }
        });
    }

    public static Map<String, Object> beanToMap(Object bean, Map<String, Object> targetMap, boolean ignoreNullValue, Editor<String> keyEditor) {
        if (bean == null) {
            return null;
        }
        Collection<BeanDesc.PropDesc> props = ClassUtils.getBeanDesc(bean.getClass()).getProps();
        for (BeanDesc.PropDesc prop : props) {
            Object value;
            String key = prop.getFieldName();
            Method getter = prop.getGetter();
            if (null == getter) continue;
            try {
                value = getter.invoke(bean, new Object[0]);
            }
            catch (Exception ignore) {
                continue;
            }
            if (ignoreNullValue && (null == value || value.equals(bean)) || null == (key = keyEditor.edit(key))) continue;
            targetMap.put(key, value);
        }
        return targetMap;
    }

    public static BeanDesc getBeanDesc(Class<?> clazz) {
        return new BeanDesc(clazz);
    }

    public static ClassLoader getClassLoader() {
        ClassLoader classLoader = ClassUtils.getContextClassLoader();
        if (classLoader == null && null == (classLoader = ClassUtils.class.getClassLoader())) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }

    public static String getClassPath() {
        return ClassUtils.getClassPath(false);
    }

    public static String getClassPath(boolean isEncoded) {
        URL classPathURL = ClassUtils.getClassPathURL();
        String url = isEncoded ? classPathURL.getPath() : UriUtils.getDecodedPath(classPathURL);
        return FileUtils.normalize(url);
    }

    public static URL getClassPathURL() {
        return ClassUtils.getResourceURL("");
    }

    public static URL getResourceURL(String resource) throws InstrumentException {
        return ResourceUtils.getResource(resource);
    }

    public static <T> T fillBean(T bean, ValueProvider<String> valueProvider, CopyOptions copyOptions) {
        if (null == valueProvider) {
            return bean;
        }
        return BeanCopier.create(valueProvider, bean, copyOptions).copy();
    }

    public static ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static <T> Class<T> loadClass(String name) throws InstrumentException {
        return ClassUtils.loadClass(name, true);
    }

    public static <T> Class<T> loadClass(String name, boolean isInitialized) throws InstrumentException {
        return ClassUtils.loadClass(name, null, isInitialized);
    }

    public static Class<?> loadClass(String name, ClassLoader classLoader, boolean isInitialized) throws InstrumentException {
        Class<?> clazz;
        block11: {
            Assert.notNull(name, "Name must not be null", new Object[0]);
            clazz = ClassUtils.loadPrimitiveClass(name);
            if (clazz == null) {
                clazz = classCache.get(name);
            }
            if (clazz != null) {
                return clazz;
            }
            if (name.endsWith("[]")) {
                String elementClassName = name.substring(0, name.length() - "[]".length());
                Class<?> elementClass = ClassUtils.loadClass(elementClassName, classLoader, isInitialized);
                clazz = Array.newInstance(elementClass, 0).getClass();
            } else if (name.startsWith("[L") && name.endsWith(";")) {
                String elementName = name.substring("[L".length(), name.length() - 1);
                Class<?> elementClass = ClassUtils.loadClass(elementName, classLoader, isInitialized);
                clazz = Array.newInstance(elementClass, 0).getClass();
            } else if (name.startsWith("[")) {
                String elementName = name.substring("[".length());
                Class<?> elementClass = ClassUtils.loadClass(elementName, classLoader, isInitialized);
                clazz = Array.newInstance(elementClass, 0).getClass();
            } else {
                if (null == classLoader) {
                    classLoader = ClassUtils.getClassLoader();
                }
                try {
                    clazz = Class.forName(name, isInitialized, classLoader);
                }
                catch (ClassNotFoundException ex) {
                    clazz = ClassUtils.tryLoadInnerClass(name, classLoader, isInitialized);
                    if (null != clazz) break block11;
                    throw new InstrumentException(ex);
                }
            }
        }
        return classCache.put(name, clazz);
    }

    public static Class<?> loadPrimitiveClass(String name) {
        Class<?> result = null;
        if (StringUtils.isNotBlank(name) && (name = name.trim()).length() <= 8) {
            result = primitiveWrapperMap.get(name);
        }
        return result;
    }

    public static JarLoaders getJarClassLoader(File jarOrDir) {
        return JarLoaders.load(jarOrDir);
    }

    public static Class<?> loadClass(File jarOrDir, String name) {
        try {
            return ClassUtils.getJarClassLoader(jarOrDir).loadClass(name);
        }
        catch (ClassNotFoundException e) {
            throw new InstrumentException(e);
        }
    }

    public static boolean isPresent(String className) {
        return ClassUtils.isPresent(className, null);
    }

    public static boolean isPresent(String className, ClassLoader classLoader) {
        try {
            ClassUtils.loadClass(className, classLoader, false);
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    private static Class<?> tryLoadInnerClass(String name, ClassLoader classLoader, boolean isInitialized) {
        int lastDotIndex = name.lastIndexOf(46);
        if (lastDotIndex > 0) {
            String innerClassName = name.substring(0, lastDotIndex) + '$' + name.substring(lastDotIndex + 1);
            try {
                return Class.forName(innerClassName, isInitialized, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    public static String getPackageName(Class<?> clazz) {
        return ClassUtils.getPackageName(clazz.getName());
    }

    public static String getPackageName(String fqClassName) {
        Assert.notNull(fqClassName, "Class name must not be null", new Object[0]);
        int lastDotIndex = fqClassName.lastIndexOf(46);
        return lastDotIndex != -1 ? fqClassName.substring(0, lastDotIndex) : "";
    }

    public static Class<?> forName(String name, ClassLoader classLoader) throws ClassNotFoundException, LinkageError {
        Assert.notNull(name, "Name must not be null", new Object[0]);
        Class<?> clazz = ClassUtils.resolvePrimitiveClassName(name);
        if (clazz != null) {
            return clazz;
        }
        if (name.endsWith("[]")) {
            String elementClassName = name.substring(0, name.length() - "[]".length());
            Class<?> elementClass = ClassUtils.forName(elementClassName, classLoader);
            return Array.newInstance(elementClass, 0).getClass();
        }
        if (name.startsWith("[L") && name.endsWith(";")) {
            String elementName = name.substring("[L".length(), name.length() - 1);
            Class<?> elementClass = ClassUtils.forName(elementName, classLoader);
            return Array.newInstance(elementClass, 0).getClass();
        }
        if (name.startsWith("[")) {
            String elementName = name.substring("[".length());
            Class<?> elementClass = ClassUtils.forName(elementName, classLoader);
            return Array.newInstance(elementClass, 0).getClass();
        }
        ClassLoader clToUse = classLoader;
        if (clToUse == null) {
            clToUse = ClassUtils.getDefaultClassLoader();
        }
        try {
            return Class.forName(name, false, clToUse);
        }
        catch (ClassNotFoundException ex) {
            int lastDotIndex = name.lastIndexOf(46);
            if (lastDotIndex != -1) {
                String innerClassName = name.substring(0, lastDotIndex) + '$' + name.substring(lastDotIndex + 1);
                try {
                    return Class.forName(innerClassName, false, clToUse);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            throw ex;
        }
    }

    public static Class<?> resolvePrimitiveClassName(String name) {
        Class<?> result = null;
        if (name != null && name.length() <= 8) {
            result = primitiveWrapperMap.get(name);
        }
        return result;
    }

    public static ClassLoader getDefaultClassLoader() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cl == null && (cl = ClassUtils.class.getClassLoader()) == null) {
            try {
                cl = ClassLoader.getSystemClassLoader();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return cl;
    }

    public static String getShortClassName(Object object, String valueIfNull) {
        if (object == null) {
            return valueIfNull;
        }
        return ClassUtils.getShortClassName(object.getClass());
    }

    public static String getShortClassName(Class<?> cls) {
        if (cls == null) {
            return "";
        }
        return ClassUtils.getShortClassName(cls.getName());
    }

    public static String getShortClassName(String className) {
        int lastDotIdx;
        if (StringUtils.isEmpty(className)) {
            return "";
        }
        StringBuilder arrayPrefix = new StringBuilder();
        if (className.startsWith("[")) {
            while (className.charAt(0) == '[') {
                className = className.substring(1);
                arrayPrefix.append("[]");
            }
            if (className.charAt(0) == 'L' && className.charAt(className.length() - 1) == ';') {
                className = className.substring(1, className.length() - 1);
            }
            if (primitiveWrapperMap.containsKey(className)) {
                className = primitiveWrapperMap.get(className).toString();
            }
        }
        int innerIdx = className.indexOf(36, (lastDotIdx = className.lastIndexOf(46)) == -1 ? 0 : lastDotIdx + 1);
        String out = className.substring(lastDotIdx + 1);
        if (innerIdx != -1) {
            out = out.replace('$', '.');
        }
        return out + arrayPrefix;
    }

    public static String getSimpleName(Class<?> cls) {
        return ClassUtils.getSimpleName(cls, "");
    }

    public static String getSimpleName(Class<?> cls, String valueIfNull) {
        return cls == null ? valueIfNull : cls.getSimpleName();
    }

    public static String getSimpleName(Object object) {
        return ClassUtils.getSimpleName(object, "");
    }

    public static String getSimpleName(Object object, String valueIfNull) {
        return object == null ? valueIfNull : object.getClass().getSimpleName();
    }

    public static Class<?> primitiveToWrapper(Class<?> cls) {
        Class<?> convertedClass = cls;
        if (cls != null && cls.isPrimitive()) {
            convertedClass = primitiveWrapperMap.get(cls);
        }
        return convertedClass;
    }

    public static Class<?>[] primitivesToWrappers(Class<?> ... classes) {
        if (classes == null) {
            return null;
        }
        if (classes.length == 0) {
            return classes;
        }
        Class[] convertedClasses = new Class[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            convertedClasses[i] = ClassUtils.primitiveToWrapper(classes[i]);
        }
        return convertedClasses;
    }

    public static Class<?> wrapperToPrimitive(Class<?> cls) {
        return wrapperPrimitiveMap.get(cls);
    }

    public static Class<?>[] wrappersToPrimitives(Class<?> ... classes) {
        if (classes == null) {
            return null;
        }
        if (classes.length == 0) {
            return classes;
        }
        Class[] convertedClasses = new Class[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            convertedClasses[i] = ClassUtils.wrapperToPrimitive(classes[i]);
        }
        return convertedClasses;
    }

    public static List<Class<?>> getAllInterfaces(Class<?> cls) {
        if (cls == null) {
            return null;
        }
        LinkedHashSet interfacesFound = new LinkedHashSet();
        ClassUtils.getAllInterfaces(cls, interfacesFound);
        return new ArrayList(interfacesFound);
    }

    public static void getAllInterfaces(Class<?> cls, HashSet<Class<?>> interfacesFound) {
        while (cls != null) {
            Class<?>[] interfaces;
            for (Class<?> i : interfaces = cls.getInterfaces()) {
                if (!interfacesFound.add(i)) continue;
                ClassUtils.getAllInterfaces(i, interfacesFound);
            }
            cls = cls.getSuperclass();
        }
    }

    public static List<Class<?>> getAllSuperclasses(Class<?> cls) {
        if (cls == null) {
            return null;
        }
        ArrayList classes = new ArrayList();
        for (Class<?> superclass = cls.getSuperclass(); superclass != null; superclass = superclass.getSuperclass()) {
            classes.add(superclass);
        }
        return classes;
    }

    public static Class<?>[] toClass(Object ... array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return ArrayUtils.EMPTY_CLASS_ARRAY;
        }
        Class[] classes = new Class[array.length];
        for (int i = 0; i < array.length; ++i) {
            classes[i] = array[i] == null ? null : array[i].getClass();
        }
        return classes;
    }

    public static Iterable<Class<?>> hierarchy(Class<?> type) {
        return ClassUtils.hierarchy(type, Interfaces.EXCLUDE);
    }

    public static Iterable<Class<?>> hierarchy(final Class<?> type, Interfaces interfacesBehavior) {
        final Iterable classes = new Iterable<Class<?>>(){

            @Override
            public Iterator<Class<?>> iterator() {
                final MutableObject<Class> next = new MutableObject<Class>(type);
                return new Iterator<Class<?>>(){

                    @Override
                    public boolean hasNext() {
                        return next.get() != null;
                    }

                    @Override
                    public Class<?> next() {
                        Class result = (Class)next.get();
                        next.set(result.getSuperclass());
                        return result;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
        if (interfacesBehavior != Interfaces.INCLUDE) {
            return classes;
        }
        return new Iterable<Class<?>>(){

            @Override
            public Iterator<Class<?>> iterator() {
                final HashSet seenInterfaces = new HashSet();
                final Iterator wrapped = classes.iterator();
                return new Iterator<Class<?>>(){
                    Iterator<Class<?>> interfaces = Collections.emptyIterator();

                    @Override
                    public boolean hasNext() {
                        return this.interfaces.hasNext() || wrapped.hasNext();
                    }

                    @Override
                    public Class<?> next() {
                        if (this.interfaces.hasNext()) {
                            Class<?> nextInterface = this.interfaces.next();
                            seenInterfaces.add(nextInterface);
                            return nextInterface;
                        }
                        Class nextSuperclass = (Class)wrapped.next();
                        LinkedHashSet currentInterfaces = new LinkedHashSet();
                        this.walkInterfaces(currentInterfaces, nextSuperclass);
                        this.interfaces = currentInterfaces.iterator();
                        return nextSuperclass;
                    }

                    private void walkInterfaces(Set<Class<?>> addTo, Class<?> c) {
                        for (Class<?> iface : c.getInterfaces()) {
                            if (!seenInterfaces.contains(iface)) {
                                addTo.add(iface);
                            }
                            this.walkInterfaces(addTo, iface);
                        }
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static boolean isPrimitiveOrWrapper(Class<?> type) {
        if (type == null) {
            return false;
        }
        return type.isPrimitive() || ClassUtils.isPrimitiveWrapper(type);
    }

    public static boolean isUserLevelMethod(Method method) {
        Assert.notNull(method, "Method must not be null", new Object[0]);
        return method.isBridge() || !method.isSynthetic() && !ClassUtils.isGroovyObjectMethod(method);
    }

    private static boolean isGroovyObjectMethod(Method method) {
        return method.getDeclaringClass().getName().equals("groovy.lang.GroovyObject");
    }

    public static String convertClassNameToResourcePath(String className) {
        Assert.notNull(className, "Class name must not be null", new Object[0]);
        return className.replace('.', '/');
    }

    public static String getClassVar(String className) {
        return className.substring(0, 1).toLowerCase() + className.substring(1);
    }

    public static List<Field> getAllFieldList(Class clazz) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (Class tempClass = clazz; tempClass != null; tempClass = tempClass.getSuperclass()) {
            fieldList.addAll(Arrays.asList(tempClass.getDeclaredFields()));
        }
        for (Field field : fieldList) {
            field.setAccessible(true);
        }
        return fieldList;
    }

    public static <T> T newInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<Method> getAllFieldsReadMethods(Class clazz) throws IntrospectionException {
        List<Field> fieldList = ClassUtils.getAllFieldList(clazz);
        if (CollUtils.isEmpty(fieldList)) {
            return Collections.emptyList();
        }
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Field field : fieldList) {
            PropertyDescriptor pd = new PropertyDescriptor(field.getName(), clazz);
            Method getMethod = pd.getReadMethod();
            methods.add(getMethod);
        }
        return methods;
    }

    static {
        ArrayList primitiveTypes = new ArrayList(32);
        primitiveTypes.addAll(BasicType.primitiveWrapperMap.keySet());
        primitiveTypes.add(boolean[].class);
        primitiveTypes.add(byte[].class);
        primitiveTypes.add(char[].class);
        primitiveTypes.add(double[].class);
        primitiveTypes.add(float[].class);
        primitiveTypes.add(int[].class);
        primitiveTypes.add(long[].class);
        primitiveTypes.add(short[].class);
        primitiveTypes.add(Void.TYPE);
        for (Class clazz : primitiveTypes) {
            primitiveWrapperMap.put(clazz.getName(), clazz);
        }
    }

    public static enum Interfaces {
        INCLUDE,
        EXCLUDE;

    }
}

