/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket.netty;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aoju.bus.socket.netty.ChannelExecutor;
import org.aoju.bus.socket.netty.CustomizeEventHandler;
import org.aoju.bus.socket.netty.EventHandler;
import org.aoju.bus.socket.netty.NettyConsts;
import org.aoju.bus.socket.netty.SocketClient;
import org.aoju.bus.socket.netty.SocketServer;

public class SocketService {
    private static Map<String, List<EventHandler>> handlers = new HashMap<String, List<EventHandler>>();
    private static List<CustomizeEventHandler> customizeHandlers = new ArrayList<CustomizeEventHandler>();

    public static void start(int port) {
        SocketService.start(port, NettyConsts.END_POINT);
    }

    public static void start(int port, String endPoint) {
        SocketService.start(port, NettyConsts.BOSS_GROUP_THREADS, NettyConsts.WORKER_GROUP_THREADS, endPoint);
    }

    public static void start(int port, int bossGroupThreads, int workerGroupThreads) {
        SocketService.start(port, bossGroupThreads, workerGroupThreads, NettyConsts.END_POINT);
    }

    public static void start(int port, int bossGroupThreads, int workerGroupThreads, String endPoint) {
        ChannelExecutor.start();
        new SocketServer(port, bossGroupThreads, workerGroupThreads, endPoint).run();
    }

    public static void addHandler(String topic, EventHandler handler) {
        handlers.computeIfAbsent(topic, k -> new ArrayList()).add(handler);
    }

    public static void addCustomizeHandler(CustomizeEventHandler customizeHandler) {
        customizeHandlers.add(customizeHandler);
    }

    public static void onSubscribe(SocketClient client, String topic, String data) {
        String message;
        List<EventHandler> eventHandlers = handlers.get(topic);
        if (eventHandlers != null && !eventHandlers.isEmpty()) {
            for (EventHandler handler : eventHandlers) {
                message = handler.onSubscribe(topic, data);
                if (message == null) continue;
                client.send(JSON.toJSONString((Object)message));
            }
        }
        for (CustomizeEventHandler customizeHandler : customizeHandlers) {
            if (!customizeHandler.equalsTopic(topic) || (message = customizeHandler.onSubscribe(topic, data)) == null) continue;
            client.send(JSON.toJSONString((Object)message));
        }
    }

    public static void onMessage(SocketClient client, String topic, String data) {
        String message;
        List<EventHandler> eventHandlers = handlers.get(topic);
        if (eventHandlers != null && !eventHandlers.isEmpty()) {
            for (EventHandler handler : eventHandlers) {
                message = handler.onMessage(topic, data);
                if (message == null) continue;
                client.send(JSON.toJSONString((Object)message));
            }
        }
        for (CustomizeEventHandler customizeHandler : customizeHandlers) {
            if (!customizeHandler.equalsTopic(topic) || (message = customizeHandler.onMessage(topic, data)) == null) continue;
            client.send(JSON.toJSONString((Object)message));
        }
    }

    public static void onCancel(SocketClient client, String topic, String data) {
        String message;
        List<EventHandler> eventHandlers = handlers.get(topic);
        if (eventHandlers != null && !eventHandlers.isEmpty()) {
            for (EventHandler handler : eventHandlers) {
                message = handler.onCancel(topic, data);
                if (message == null) continue;
                client.send(JSON.toJSONString((Object)message));
            }
        }
        for (CustomizeEventHandler customizeHandler : customizeHandlers) {
            if (!customizeHandler.equalsTopic(topic) || (message = customizeHandler.onCancel(topic, data)) == null) continue;
            client.send(JSON.toJSONString((Object)message));
        }
    }
}

