/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.convert.impl;

import java.util.Map;
import org.aoju.bus.core.beans.copier.BeanCopier;
import org.aoju.bus.core.beans.copier.CopyOptions;
import org.aoju.bus.core.beans.copier.ValueProvider;
import org.aoju.bus.core.convert.AbstractConverter;
import org.aoju.bus.core.utils.BeanUtils;
import org.aoju.bus.core.utils.ReflectUtils;

public class BeanConverter<T>
extends AbstractConverter<T> {
    private Class<T> beanClass;
    private CopyOptions copyOptions;

    public BeanConverter(Class<T> beanClass) {
        this(beanClass, CopyOptions.create().setIgnoreError(true));
        this.beanClass = beanClass;
    }

    public BeanConverter(Class<T> beanClass, CopyOptions copyOptions) {
        this.beanClass = beanClass;
        this.copyOptions = copyOptions;
    }

    @Override
    protected T convertInternal(Object value) {
        if (value instanceof Map || value instanceof ValueProvider || BeanUtils.isBean(value.getClass())) {
            return BeanCopier.create(value, ReflectUtils.newInstanceIfPossible(this.beanClass), this.copyOptions).copy();
        }
        return null;
    }

    @Override
    public Class<T> getTargetType() {
        return this.beanClass;
    }
}

