/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.utils;

public class CompareUtils {
    public static <T extends Comparable<? super T>> int compare(T c1, T c2) {
        return CompareUtils.compare(c1, c2, false);
    }

    public static <T extends Comparable<? super T>> int compare(T c1, T c2, boolean isNullGreater) {
        if (c1 == c2) {
            return 0;
        }
        if (c1 == null) {
            return isNullGreater ? 1 : -1;
        }
        if (c2 == null) {
            return isNullGreater ? -1 : 1;
        }
        return c1.compareTo(c2);
    }

    public static int compare(String v1, String v2, boolean complete) {
        if (v1 == v2) {
            return 0;
        }
        if (v1 == null) {
            return -1;
        }
        if (v2 == null) {
            return 1;
        }
        if ((v1 = v1.trim()).equals(v2 = v2.trim())) {
            return 0;
        }
        String[] v1s = v1.split("\\.");
        String[] v2s = v2.split("\\.");
        int v1sLen = v1s.length;
        int v2sLen = v2s.length;
        int len = complete ? Math.max(v1sLen, v2sLen) : Math.min(v1sLen, v2sLen);
        for (int i = 0; i < len; ++i) {
            String c2;
            String c1 = len > v1sLen || null == v1s[i] ? "" : v1s[i];
            int result = c1.compareTo(c2 = len > v2sLen || null == v2s[i] ? "" : v2s[i]);
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    public static <T> int compare(T o1, T o2, boolean isNullGreater) {
        if (o1 == o2) {
            return 0;
        }
        if (null == o1) {
            return isNullGreater ? 1 : -1;
        }
        if (null == o2) {
            return isNullGreater ? -1 : 1;
        }
        if (o1 instanceof Comparable && o2 instanceof Comparable) {
            return ((Comparable)o1).compareTo(o2);
        }
        if (o1.equals(o2)) {
            return 0;
        }
        int result = Integer.compare(o1.hashCode(), o2.hashCode());
        if (0 == result) {
            result = CompareUtils.compare(o1.toString(), o2.toString());
        }
        return result;
    }
}

